/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.xf;

import com.adobe.cq.xf.ExperienceFragment;
import com.adobe.cq.xf.ExperienceFragmentVariation;
import com.day.cq.wcm.api.Page;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockExperienceFragmentTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Before
    public void setUp() {
        ContentLoader contentLoader = this.context.load();
        contentLoader.json("/json-import-samples/xf.json", "/content/experience-fragments/sample");
    }

    @Test
    public void testExperienceFragment() {
        Resource xfResource = this.context.resourceResolver().getResource("/content/experience-fragments/sample");
        Page xfPage = (Page)xfResource.adaptTo(Page.class);
        Assert.assertNull((Object)xfPage.adaptTo(ExperienceFragmentVariation.class));
        ExperienceFragment experienceFragment = (ExperienceFragment)xfPage.adaptTo(ExperienceFragment.class);
        Assert.assertNotNull((Object)experienceFragment);
        Resource adaptedResource = (Resource)experienceFragment.adaptTo(Resource.class);
        Assert.assertEquals((Object)xfResource, (Object)adaptedResource);
        Page adaptedPage = (Page)experienceFragment.adaptTo(Page.class);
        Assert.assertEquals((Object)xfPage, (Object)adaptedPage);
        Assert.assertEquals((Object)"/content/experience-fragments/sample", (Object)experienceFragment.getPath());
        Assert.assertEquals((Object)"/conf/something", experienceFragment.getCloudserviceConfigurationsPaths().get(0));
        Assert.assertEquals((long)2L, (long)experienceFragment.getVariations().size());
        Assert.assertEquals((long)1L, (long)experienceFragment.getVariations(new String[]{"facebook"}).size());
        Assert.assertEquals((Object)"/content/experience-fragments/sample/master", (Object)((ExperienceFragmentVariation)experienceFragment.getVariations().get(0)).getPath());
        Assert.assertEquals((Object)"Header", (Object)experienceFragment.getProperties().get((Object)"jcr:title"));
    }

    @Test
    public void testExperienceFragmentVariation() {
        Resource masterResource = this.context.resourceResolver().getResource("/content/experience-fragments/sample/master");
        Page masterPage = (Page)masterResource.adaptTo(Page.class);
        Assert.assertNull((Object)masterPage.adaptTo(ExperienceFragment.class));
        ExperienceFragmentVariation variation = (ExperienceFragmentVariation)masterPage.adaptTo(ExperienceFragmentVariation.class);
        Assert.assertNotNull((Object)variation);
        Resource adaptedResource = (Resource)variation.adaptTo(Resource.class);
        Assert.assertEquals((Object)masterResource, (Object)adaptedResource);
        Page adaptedPage = (Page)variation.adaptTo(Page.class);
        Assert.assertEquals((Object)masterPage, (Object)adaptedPage);
        Assert.assertEquals((Object)"/content/experience-fragments/sample/master", (Object)variation.getPath());
        Assert.assertEquals((Object)"/conf/something", variation.getCloudserviceConfigurationsPaths().get(0));
        Assert.assertEquals((Object)"/conf/something", (Object)variation.getPropertiesTree().getInherited("cq:cloudserviceconfigs", (Object)""));
        Assert.assertEquals((Object)"web", (Object)variation.getType());
        Assert.assertEquals((Object)"/content/experience-fragments/sample", (Object)variation.getParent().getPath());
        Assert.assertEquals((Object)"Header", (Object)variation.getProperties().get((Object)"jcr:title"));
    }
}

