/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Designer;
import io.wcm.testing.mock.aem.MockAsset;
import io.wcm.testing.mock.aem.MockComponentManager;
import io.wcm.testing.mock.aem.MockDesigner;
import io.wcm.testing.mock.aem.MockPage;
import io.wcm.testing.mock.aem.MockPageManager;
import io.wcm.testing.mock.aem.MockRendition;
import io.wcm.testing.mock.aem.MockTag;
import io.wcm.testing.mock.aem.MockTagManager;
import io.wcm.testing.mock.aem.MockTemplate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

@Component
@Service(value={AdapterFactory.class})
@ProviderType
public class MockAemAdapterFactory
implements AdapterFactory {
    @Property(name="adaptables")
    private static final String[] ADAPTABLES = new String[]{Resource.class.getName(), ResourceResolver.class.getName()};
    @Property(name="adapters")
    private static final String[] ADAPTERS = new String[]{Page.class.getName(), Template.class.getName(), Asset.class.getName(), Rendition.class.getName(), PageManager.class.getName(), ComponentManager.class.getName(), TagManager.class.getName(), Tag.class.getName(), Designer.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == Page.class && this.isPrimaryType(resource, "cq:Page")) {
            return (AdapterType)((Object)new MockPage(resource));
        }
        if (type == Template.class && this.isPrimaryType(resource, "cq:Template")) {
            return (AdapterType)((Object)new MockTemplate(resource));
        }
        if (type == Asset.class && DamUtil.isAsset((Resource)resource)) {
            return (AdapterType)((Object)new MockAsset(resource));
        }
        if (type == Rendition.class && DamUtil.isRendition((Resource)resource)) {
            return (AdapterType)((Object)new MockRendition(resource));
        }
        if (type == Tag.class && this.isPrimaryType(resource, "cq:Tag")) {
            return (AdapterType)new MockTag(resource);
        }
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resolver, Class<AdapterType> type) {
        if (type == PageManager.class) {
            return (AdapterType)((Object)new MockPageManager(resolver));
        }
        if (type == ComponentManager.class) {
            return (AdapterType)new MockComponentManager(resolver);
        }
        if (type == TagManager.class) {
            return (AdapterType)new MockTagManager(resolver);
        }
        if (type == Designer.class) {
            return (AdapterType)new MockDesigner();
        }
        return null;
    }

    private boolean isPrimaryType(Resource resource, String primaryType) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                return StringUtils.equals((CharSequence)node.getPrimaryNodeType().getName(), (CharSequence)primaryType);
            }
            catch (RepositoryException ex) {
                return false;
            }
        }
        ValueMap props = resource.getValueMap();
        return StringUtils.equals((CharSequence)((CharSequence)props.get("jcr:primaryType", String.class)), (CharSequence)primaryType);
    }
}

