/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Template;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

class MockTemplate
extends ResourceWrapper
implements Template {
    private final Resource resource;
    private final ValueMap properties;

    MockTemplate(Resource resource) {
        super(resource);
        this.resource = resource;
        this.properties = resource.getValueMap();
    }

    public String getTitle() {
        return (String)this.properties.get("jcr:title", String.class);
    }

    public String getShortTitle() {
        return (String)this.properties.get("shortTitle", String.class);
    }

    public String getDescription() {
        return (String)this.properties.get("jcr:description", String.class);
    }

    public String getIconPath() {
        Resource iconResource = this.resource.getChild("icon.png");
        if (iconResource != null) {
            return iconResource.getPath();
        }
        return null;
    }

    public String getThumbnailPath() {
        Resource thumbnailResource = this.resource.getChild("thumbnail.png");
        if (thumbnailResource != null) {
            return thumbnailResource.getPath();
        }
        return null;
    }

    public Long getRanking() {
        return (Long)this.properties.get("ranking", Long.class);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockTemplate)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getPath(), (CharSequence)((MockTemplate)((Object)obj)).getPath());
    }

    public boolean isAllowed(String parentPath) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedChild(Template template) {
        throw new UnsupportedOperationException();
    }

    public void write(JSONWriter jsonWriter) throws JSONException {
        throw new UnsupportedOperationException();
    }
}

