/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.builder;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.image.Layer;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContentBuilder
extends org.apache.sling.testing.mock.sling.builder.ContentBuilder {
    static final String DUMMY_TEMPLATE = "/apps/sample/templates/template1";

    public ContentBuilder(ResourceResolver resourceResolver) {
        super(resourceResolver);
    }

    public Page page(String path) {
        return this.page(path, DUMMY_TEMPLATE, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(String path, String template) {
        return this.page(path, template, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(String path, String template, String title) {
        return this.page(path, template, (Map<String, Object>)ImmutableMap.builder().put((Object)"jcr:title", (Object)title).build());
    }

    public Page page(String path, String template, Map<String, Object> contentProperties) {
        String parentPath = ResourceUtil.getParent((String)path);
        this.ensureResourceExists(parentPath);
        String name = ResourceUtil.getName((String)path);
        try {
            PageManager pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
            Page page = pageManager.create(parentPath, name, template, name, true);
            if (!contentProperties.isEmpty()) {
                ModifiableValueMap pageProperties = (ModifiableValueMap)page.getContentResource().adaptTo(ModifiableValueMap.class);
                pageProperties.putAll(contentProperties);
                this.resourceResolver.commit();
            }
            return page;
        }
        catch (WCMException | PersistenceException ex) {
            throw new RuntimeException("Unable to create page at " + path, ex);
        }
    }

    public Asset asset(String path, String classpathResource, String mimeType) {
        return this.asset(path, classpathResource, mimeType, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Asset asset(String path, String classpathResource, String mimeType, Map<String, Object> metadata) {
        try (InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);){
            if (is == null) {
                throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
            }
            Asset asset = this.asset(path, is, mimeType, metadata);
            return asset;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Asset asset(String path, int width, int height, String mimeType) {
        return this.asset(path, width, height, mimeType, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Asset asset(String path, int width, int height, String mimeType, Map<String, Object> metadata) {
        try (InputStream is = ContentBuilder.createDummyImage(width, height, mimeType);){
            Asset asset = this.asset(path, is, mimeType, metadata);
            return asset;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Asset asset(String path, InputStream inputStream, String mimeType) {
        return this.asset(path, inputStream, mimeType, null);
    }

    public Asset asset(String path, InputStream inputStream, String mimeType, Map<String, Object> metadata) {
        try {
            this.resource(path, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"dam:Asset").build());
            this.resource(path + "/" + "jcr:content", (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"dam:AssetContent").build());
            String renditionsPath = path + "/" + "jcr:content" + "/" + "renditions";
            this.resource(renditionsPath, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:folder").build());
            HashMap<String, Object> metadataProps = new HashMap<String, Object>();
            if (metadata != null) {
                metadataProps.putAll(metadata);
            }
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                try {
                    Layer layer = new Layer((InputStream)is);
                    metadataProps.put("tiff:ImageWidth", layer.getWidth());
                    metadataProps.put("tiff:ImageLength", layer.getHeight());
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            this.resource(path + "/" + "jcr:content" + "/" + "metadata", metadataProps);
            is = new ByteArrayInputStream(data);
            var9_10 = null;
            try {
                new ContentLoader(this.resourceResolver).binaryFile((InputStream)is, renditionsPath + "/" + "original", mimeType);
            }
            catch (Throwable throwable) {
                var9_10 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var9_10 != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable) {
                            var9_10.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
            this.resourceResolver.commit();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create asset at " + path, ex);
        }
        return (Asset)this.resourceResolver.getResource(path).adaptTo(Asset.class);
    }

    public static InputStream createDummyImage(int width, int height, String mimeType) {
        byte[] data;
        Layer layer = new Layer(width, height, null);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            double quality = StringUtils.equals((CharSequence)mimeType, (CharSequence)"image/gif") ? 256.0 : 1.0;
            layer.write(mimeType, quality, (OutputStream)bos);
            data = bos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rendition assetRendition(Asset asset, String name, String classpathResource, String mimeType) {
        try (InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);){
            if (is == null) {
                throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
            }
            Rendition rendition = this.assetRendition(asset, name, is, mimeType);
            return rendition;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rendition assetRendition(Asset asset, String name, int width, int height, String mimeType) {
        try (InputStream is = ContentBuilder.createDummyImage(width, height, mimeType);){
            Rendition rendition = this.assetRendition(asset, name, is, mimeType);
            return rendition;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Rendition assetRendition(Asset asset, String name, InputStream inputStream, String mimeType) {
        return asset.addRendition(name, inputStream, mimeType);
    }

    public Tag tag(String tagId) {
        TagManager tagManager = (TagManager)this.resourceResolver.adaptTo(TagManager.class);
        String tagTitle = ResourceUtil.getName((String)StringUtils.substringAfter((String)tagId, (String)":"));
        try {
            return tagManager.createTag(tagId, tagTitle, null, true);
        }
        catch (InvalidTagFormatException | AccessControlException ex) {
            throw new RuntimeException("Unable to create tag: " + tagId, ex);
        }
    }
}

