/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.collect.ImmutableSet;
import io.wcm.testing.mock.aem.MockAemAdapterFactory;
import io.wcm.testing.mock.aem.MockComponentContext;
import io.wcm.testing.mock.aem.MockLayerAdapterFactory;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import io.wcm.testing.mock.aem.context.ContextResourceResolverFactory;
import io.wcm.testing.mock.aem.context.UniqueRoot;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public class AemContextImpl
extends SlingContextImpl {
    static final Set<String> DEFAULT_RUN_MODES = ImmutableSet.builder().add((Object)"publish").build();
    private static final String RESOURCERESOLVERFACTORYACTIVATOR_PID = "org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl";
    private static final Logger log = LoggerFactory.getLogger(AemContextImpl.class);

    protected void registerDefaultServices() {
        super.registerDefaultServices();
        this.registerInjectActivateService(new MockAemAdapterFactory());
        this.registerInjectActivateService(new MockLayerAdapterFactory());
    }

    protected void setResourceResolverType(ResourceResolverType resourceResolverType) {
        super.setResourceResolverType(resourceResolverType);
    }

    protected ResourceResolverFactory newResourceResolverFactory() {
        return ContextResourceResolverFactory.get(this.resourceResolverType, this.bundleContext());
    }

    protected void setUp() {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.getService(ConfigurationAdmin.class);
        if (configAdmin == null) {
            log.warn("ConfigAdmin not found in osgi-mock context - please make sure osgi-mock 1.7.0 or higher is used.");
        } else {
            try {
                Configuration resourceResolverFactoryActivatorConfig = configAdmin.getConfiguration(RESOURCERESOLVERFACTORYACTIVATOR_PID);
                Hashtable<String, Object> defaultProps = new Hashtable<String, Object>();
                ((Dictionary)defaultProps).put("resource.resolver.searchpath", new String[]{"/apps", "/libs", "/apps/foundation/components/primary", "/libs/foundation/components/primary"});
                ((Dictionary)defaultProps).put("resource.resolver.manglenamespaces", true);
                ((Dictionary)defaultProps).put("resource.resolver.allowDirect", true);
                ((Dictionary)defaultProps).put("resource.resolver.virtual", new String[]{"/:/"});
                ((Dictionary)defaultProps).put("resource.resolver.mapping", new String[]{"/-/"});
                ((Dictionary)defaultProps).put("resource.resolver.map.location", "/etc/map");
                ((Dictionary)defaultProps).put("resource.resolver.default.vanity.redirect.status", "");
                ((Dictionary)defaultProps).put("resource.resolver.virtual", "302");
                ((Dictionary)defaultProps).put("resource.resolver.enable.vanitypath", true);
                ((Dictionary)defaultProps).put("resource.resolver.vanitypath.maxEntries", -1);
                ((Dictionary)defaultProps).put("resource.resolver.vanitypath.bloomfilter.maxBytes", 1024000);
                ((Dictionary)defaultProps).put("resource.resolver.optimize.alias.resolution", true);
                ((Dictionary)defaultProps).put("resource.resolver.vanitypath.whitelist", new String[]{"/apps/", "/libs/", "/content/"});
                ((Dictionary)defaultProps).put("resource.resolver.vanitypath.blacklist", new String[]{"/content/usergenerated"});
                ((Dictionary)defaultProps).put("resource.resolver.vanity.precedence", false);
                ((Dictionary)defaultProps).put("resource.resolver.providerhandling.paranoid", false);
                resourceResolverFactoryActivatorConfig.update(defaultProps);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        super.setUp();
    }

    protected void tearDown() {
        super.tearDown();
    }

    public PageManager pageManager() {
        return (PageManager)this.resourceResolver().adaptTo(PageManager.class);
    }

    public ContentBuilder create() {
        if (this.contentBuilder == null) {
            this.contentBuilder = new ContentBuilder(this.resourceResolver());
        }
        return (ContentBuilder)this.contentBuilder;
    }

    public Page currentPage() {
        ComponentContext context = WCMUtils.getComponentContext((ServletRequest)this.request());
        if (context != null) {
            return context.getPage();
        }
        if (this.currentResource() != null) {
            return this.pageManager().getContainingPage(this.currentResource());
        }
        return null;
    }

    public Page currentPage(String pagePath) {
        if (pagePath != null) {
            Page page = this.pageManager().getPage(pagePath);
            if (page == null) {
                throw new IllegalArgumentException("Page does not exist: " + pagePath);
            }
            return this.currentPage(page);
        }
        this.currentResource(null);
        return null;
    }

    public Page currentPage(Page page) {
        if (page != null) {
            MockComponentContext wcmComponentContext = new MockComponentContext(page, (SlingHttpServletRequest)this.request());
            this.request.setAttribute("com.day.cq.wcm.componentcontext", (Object)wcmComponentContext);
            this.currentResource(page.getContentResource());
            return page;
        }
        this.request.setAttribute("com.day.cq.wcm.componentcontext", null);
        this.currentResource(null);
        return null;
    }

    public UniqueRoot uniqueRoot() {
        if (this.uniqueRoot == null) {
            this.uniqueRoot = new UniqueRoot(this);
        }
        return (UniqueRoot)this.uniqueRoot;
    }
}

