/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.collect.ImmutableSet;
import io.wcm.wcm.parsys.componentinfo.AllowedComponentsProvider;
import io.wcm.wcm.parsys.componentinfo.ParsysConfig;
import io.wcm.wcm.parsys.componentinfo.ParsysConfigManager;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AllowedComponentsProvider.class}, immediate=true)
public final class AllowedComponentsProviderImpl
implements AllowedComponentsProvider {
    @Reference
    private ParsysConfigManager parsysConfigManager;

    @Override
    public Set<String> getAllowedComponents(String resourcePath, ResourceResolver resolver) {
        HashSet<String> allowedComponents = new HashSet<String>();
        HashSet<String> deniedComponents = new HashSet<String>();
        PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resourcePath);
        if (page == null && StringUtils.contains((CharSequence)resourcePath, (CharSequence)"/jcr:content")) {
            page = pageManager.getPage(StringUtils.substringBefore((String)resourcePath, (String)"/jcr:content"));
        }
        if (page != null) {
            String pageComponentPath = page.getContentResource().getResourceType();
            String relativePath = resourcePath.substring(page.getPath().length() + 1);
            Iterable<ParsysConfig> parSysConfigs = this.parsysConfigManager.getParsysConfigs(pageComponentPath, relativePath, resolver);
            Resource parentResource = null;
            Resource grandParentResource = null;
            for (ParsysConfig pathDef : parSysConfigs) {
                boolean includePathDef = false;
                if (pathDef.getAllowedParents().size() == 0) {
                    includePathDef = true;
                } else {
                    Resource checkResource = null;
                    if (pathDef.getParentAncestorLevel() == 1) {
                        if (parentResource == null) {
                            parentResource = resolver.getResource(resourcePath);
                        }
                        checkResource = parentResource;
                    }
                    if (pathDef.getParentAncestorLevel() == 2) {
                        if (grandParentResource == null) {
                            grandParentResource = resolver.getResource(resourcePath + "/..");
                        }
                        checkResource = grandParentResource;
                    }
                    if (checkResource != null) {
                        String resourceType = checkResource.getResourceType();
                        includePathDef = pathDef.getAllowedParents().contains(resourceType);
                    }
                }
                if (!includePathDef) continue;
                allowedComponents.addAll(pathDef.getAllowedChildren());
                deniedComponents.addAll(pathDef.getDeniedChildren());
            }
        }
        allowedComponents.removeAll(deniedComponents);
        return allowedComponents;
    }

    @Override
    public Set<String> getAllowedComponentsForTemplate(String pageComponentPath, ResourceResolver resolver) {
        Resource pageComponentResource = resolver.getResource(pageComponentPath);
        if (pageComponentResource != null) {
            Iterable<ParsysConfig> parSysConfigs = this.parsysConfigManager.getParsysConfigs(pageComponentResource.getPath(), resolver);
            TreeSet<String> allowedChildren = new TreeSet<String>();
            for (ParsysConfig parSysConfig : parSysConfigs) {
                allowedChildren.addAll(parSysConfig.getAllowedChildren());
            }
            return allowedChildren;
        }
        return ImmutableSet.of();
    }
}

