/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.commons.request.RequestParam;
import io.wcm.sling.commons.resource.ResourceType;
import io.wcm.wcm.commons.util.RunMode;
import io.wcm.wcm.parsys.componentinfo.AllowedComponentsProvider;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=json", "sling.servlet.selectors=wcmio-parsys-components", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET"})
@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public final class ParsysComponentsServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    static final String RP_PATH = "path";
    static final String SELECTOR = "wcmio-parsys-components";
    private static final Logger log = LoggerFactory.getLogger(ParsysComponentsServlet.class);
    @Reference
    private AllowedComponentsProvider allowedComponentsProvider;
    @Reference
    private SlingSettingsService slingSettings;
    private boolean enabled;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.enabled = !RunMode.disableIfNotAuthor((Set)this.slingSettings.getRunModes(), (ComponentContext)componentContext, (Logger)log);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.enabled) {
            response.sendError(404);
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)resolver, PageManager.class);
        Page currentPage = pageManager.getContainingPage(request.getResource());
        if (currentPage == null) {
            response.sendError(404);
            return;
        }
        long startTime = 0L;
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        response.setContentType("application/json;charset=UTF-8");
        JSONArray allowedComponents = new JSONArray();
        String relativePath = RequestParam.get((ServletRequest)request, (String)RP_PATH);
        String fullPath = null;
        if (StringUtils.isNotEmpty((CharSequence)relativePath)) {
            fullPath = currentPage.getPath() + "/" + relativePath;
            Set<String> allowed = this.allowedComponentsProvider.getAllowedComponents(fullPath, resolver);
            TreeSet<String> allowedComponentsRelative = new TreeSet<String>();
            for (String resourceType : allowed) {
                allowedComponentsRelative.add(ResourceType.makeAbsolute((String)resourceType, (ResourceResolver)resolver));
            }
            allowedComponents = new JSONArray(allowedComponentsRelative);
        }
        response.getWriter().write(allowedComponents.toString());
        if (log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            log.debug("ParsysComponentsServlet for " + fullPath + " took " + duration + "ms");
        }
    }
}

