/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.wcm.sling.commons.resource.ResourceType;
import io.wcm.wcm.parsys.componentinfo.ParsysConfig;
import io.wcm.wcm.parsys.componentinfo.ParsysConfigManager;
import io.wcm.wcm.parsys.componentinfo.impl.ResourceParsysConfigProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import wcmiowcmparsys.org.apache.sling.commons.osgi.Order;
import wcmiowcmparsys.org.apache.sling.commons.osgi.RankedServices;

@Component(service={ParsysConfigManager.class}, immediate=true, reference={@Reference(service=ParsysConfig.class, name="parsysConfig", bind="bindParsysConfig", unbind="unbindParsysConfig", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public final class ParsysConfigManagerImpl
implements ParsysConfigManager {
    private final RankedServices<ParsysConfig> osgiParsysConfigs = new RankedServices(Order.ASCENDING);

    @Override
    public Iterable<ParsysConfig> getParsysConfigs(String pageComponentPath, ResourceResolver resolver) {
        Resource pageComponentResource = resolver.getResource(pageComponentPath);
        if (pageComponentResource != null) {
            return ImmutableList.copyOf(this.getParsysConfigsWithInheritance(pageComponentResource, resolver));
        }
        return ImmutableList.of();
    }

    @Override
    public Iterable<ParsysConfig> getParsysConfigs(String pageComponentPath, final String relativePath, ResourceResolver resolver) {
        Iterable<ParsysConfig> configs = this.getParsysConfigs(pageComponentPath, resolver);
        return Iterables.filter(configs, (Predicate)new Predicate<ParsysConfig>(){

            public boolean apply(ParsysConfig parsysConfig) {
                if (parsysConfig == null || parsysConfig.getPathPattern() == null) {
                    return false;
                }
                return parsysConfig.getPathPattern().matcher(relativePath).matches();
            }
        });
    }

    private Collection<ParsysConfig> getParsysConfigs(Resource pageComponentResource) {
        ArrayList<ParsysConfig> configs = new ArrayList<ParsysConfig>();
        ResourceParsysConfigProvider resourceParsysConfigProvider = new ResourceParsysConfigProvider(pageComponentResource);
        configs.addAll(resourceParsysConfigProvider.getPathDefs());
        for (ParsysConfig osgiParsysConfig : this.osgiParsysConfigs) {
            if (!ResourceType.equals((String)pageComponentResource.getPath(), (String)osgiParsysConfig.getPageComponentPath(), (ResourceResolver)pageComponentResource.getResourceResolver())) continue;
            configs.add(osgiParsysConfig);
        }
        return configs;
    }

    private Collection<ParsysConfig> getParsysConfigsWithInheritance(Resource pageComponentResource, ResourceResolver resolver) {
        Resource superResource;
        ArrayList<ParsysConfig> configs = new ArrayList<ParsysConfig>();
        configs.addAll(this.getParsysConfigs(pageComponentResource));
        String resourceSuperType = pageComponentResource.getResourceSuperType();
        if (StringUtils.isNotEmpty((CharSequence)resourceSuperType) && (superResource = resolver.getResource(resourceSuperType)) != null) {
            configs.addAll(this.getParsysConfigsWithInheritance(superResource, resolver));
        }
        return configs;
    }

    void bindParsysConfig(ParsysConfig service, Map<String, Object> props) {
        this.osgiParsysConfigs.bind(service, props);
    }

    void unbindParsysConfig(ParsysConfig service, Map<String, Object> props) {
        this.osgiParsysConfigs.unbind(service, props);
    }
}

