/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import com.google.common.collect.ImmutableSet;
import io.wcm.wcm.parsys.componentinfo.ParsysConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

final class ResourceParsysConfigProvider {
    private static final String NN_PATHS = "paths";
    private static final String PN_PATH = "path";
    private static final String PN_PATTERN = "pattern";
    private static final String PN_ALLOWEDCHILDREN = "allowedChildren";
    private static final String PN_ALLOWEDPARENTS = "allowedParents";
    private static final String PN_PARENTANCESTORLEVEL = "parentAncestorLevel";
    private final List<ParsysConfig> pathDefs;

    ResourceParsysConfigProvider(Resource pageComponentResource) {
        this.pathDefs = ResourceParsysConfigProvider.getPathDefs(pageComponentResource);
    }

    private static List<ParsysConfig> getPathDefs(Resource pageComponentResource) {
        ArrayList<ParsysConfig> pathDefs = new ArrayList<ParsysConfig>();
        ResourceResolver resourceResolver = pageComponentResource.getResourceResolver();
        Resource pathsResource = resourceResolver.getResource(pageComponentResource, "./wcmio:parsysConfig/paths");
        if (pathsResource != null) {
            Iterator pathDefResources = resourceResolver.listChildren(pathsResource);
            while (pathDefResources.hasNext()) {
                Resource pathDefResource = (Resource)pathDefResources.next();
                pathDefs.add(new PathDef(pathDefResource, pageComponentResource.getResourceType()));
            }
        }
        return pathDefs;
    }

    public List<ParsysConfig> getPathDefs() {
        return this.pathDefs;
    }

    private static class PathDef
    implements ParsysConfig {
        private final String pageComponentPath;
        private final Pattern pathPattern;
        private final Set<String> allowedChildren;
        private final Set<String> deniedChildren;
        private final Set<String> allowedParents;
        private final int parentAncestorLevel;

        PathDef(Resource pathDefResource, String pageComponentPath) {
            this.pageComponentPath = pageComponentPath;
            ValueMap pathDefProps = (ValueMap)pathDefResource.adaptTo(ValueMap.class);
            String path = (String)pathDefProps.get(ResourceParsysConfigProvider.PN_PATH, String.class);
            String patternString = (String)pathDefProps.get(ResourceParsysConfigProvider.PN_PATTERN, String.class);
            if (StringUtils.isNotEmpty((CharSequence)patternString)) {
                this.pathPattern = Pattern.compile(patternString);
            } else if (StringUtils.isNotBlank((CharSequence)path)) {
                this.pathPattern = Pattern.compile("^" + Pattern.quote(path) + "$");
            } else {
                String name = Text.getName((String)pathDefResource.getPath());
                this.pathPattern = Pattern.compile("^" + Pattern.quote("jcr:content/" + name) + "$");
            }
            String[] allowedChildrenArray = (String[])pathDefProps.get(ResourceParsysConfigProvider.PN_ALLOWEDCHILDREN, String[].class);
            HashSet<String> allowedChildrenSet = new HashSet<String>();
            if (allowedChildrenArray != null) {
                for (String resourceType : allowedChildrenArray) {
                    allowedChildrenSet.add(resourceType);
                }
            }
            this.allowedChildren = ImmutableSet.copyOf(allowedChildrenSet);
            String[] allowedParentsArray = (String[])pathDefProps.get(ResourceParsysConfigProvider.PN_ALLOWEDPARENTS, String[].class);
            HashSet<String> allowedParentsSet = new HashSet<String>();
            if (allowedParentsArray != null) {
                for (String resourceType : allowedParentsArray) {
                    allowedParentsSet.add(resourceType);
                }
            }
            this.allowedParents = ImmutableSet.copyOf(allowedParentsSet);
            this.parentAncestorLevel = (Integer)pathDefProps.get(ResourceParsysConfigProvider.PN_PARENTANCESTORLEVEL, (Object)1);
            this.deniedChildren = ImmutableSet.of();
        }

        @Override
        public String getPageComponentPath() {
            return this.pageComponentPath;
        }

        @Override
        public Pattern getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public Set<String> getAllowedChildren() {
            return this.allowedChildren;
        }

        @Override
        public Set<String> getDeniedChildren() {
            return this.deniedChildren;
        }

        @Override
        public Set<String> getAllowedParents() {
            return this.allowedParents;
        }

        @Override
        public int getParentAncestorLevel() {
            return this.parentAncestorLevel;
        }

        public String toString() {
            return this.pathPattern.toString() + ", children=[" + StringUtils.join(this.allowedChildren, (String)",") + "], parents=[" + StringUtils.join(this.allowedParents, (String)",") + "], parentAncestorLevel=" + this.parentAncestorLevel;
        }
    }
}

