/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.controller;

import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.google.common.collect.ImmutableMap;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.parsys.controller.CssBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public final class Parsys {
    static final String RA_PARSYS_PARENT_RESOURCE = "parsysParentResource";
    static final String SECTION_DEFAULT_CLASS_NAME = "section";
    static final String NEWAREA_RESOURCE_PATH = "./*";
    static final String NEWAREA_STYLE = "clear:both";
    static final String NEWAREA_CSS_CLASS_NAME = "new";
    static final String NEWAREA_CHILD_NAME = "newpar";
    static final String FALLBACK_NEWAREA_RESOURCE_TYPE = "wcm-io/wcm/parsys/components/parsys/newpar";
    static final String DEFAULT_ELEMENT_NAME = "div";
    @RequestAttribute(name="parsysParentResource", optional=true)
    private Resource parsysParentResource;
    @SlingObject
    private Resource currentResource;
    @SlingObject
    private ResourceResolver resolver;
    @AemObject
    private WCMMode wcmMode;
    @AemObject
    private ComponentContext componentContext;
    private ComponentManager componentManager;
    private boolean generateDefaultCss;
    private String paragraphCss;
    private String newAreaCss;
    private String paragraphElementName;
    private String wrapperElementName;
    private String wrapperCss;
    private List<Item> items;

    @PostConstruct
    private void activate() {
        ValueMap props = this.componentContext.getComponent().getProperties();
        this.generateDefaultCss = (Boolean)props.get("wcmio:parsysGenerateDefaultCss", (Object)true);
        this.paragraphCss = (String)props.get("wcmio:parsysParagraphCss", String.class);
        this.newAreaCss = (String)props.get("wcmio:parsysNewAreaCss", String.class);
        this.paragraphElementName = (String)props.get("wcmio:parsysParagraphElement", String.class);
        this.wrapperElementName = (String)props.get("wcmio:parsysWrapperElement", String.class);
        this.wrapperCss = (String)props.get("wcmio:parsysWrapperCss", String.class);
        this.items = new ArrayList<Item>();
        if (this.parsysParentResource == null) {
            this.parsysParentResource = this.currentResource;
        }
        for (Resource childResource : this.parsysParentResource.getChildren()) {
            this.items.add(this.createResourceItem(childResource));
        }
        if (this.wcmMode != WCMMode.DISABLED) {
            this.items.add(this.createNewAreaItem());
        }
    }

    private Item createResourceItem(Resource resource) {
        CssBuilder css = new CssBuilder();
        if (this.generateDefaultCss) {
            css.add(SECTION_DEFAULT_CLASS_NAME);
        }
        css.add(this.paragraphCss);
        Map<String, String> htmlTagAttrs = this.getComponentHtmlTagAttributes(resource.getResourceType());
        String itemElementName = this.paragraphElementName;
        if (StringUtils.isEmpty((CharSequence)itemElementName)) {
            itemElementName = StringUtils.defaultString((String)htmlTagAttrs.get("cq:tagName"), (String)DEFAULT_ELEMENT_NAME);
        }
        if (StringUtils.isEmpty((CharSequence)this.paragraphCss)) {
            css.add(htmlTagAttrs.get("class"));
        }
        return new Item(resource.getPath(), null, itemElementName, null, css.build(), false);
    }

    private Map<String, String> getComponentHtmlTagAttributes(String resourceType) {
        Component component;
        if (StringUtils.isNotEmpty((CharSequence)resourceType) && (component = this.componentManager().getComponent(resourceType)) != null && component.getHtmlTagAttributes() != null) {
            return component.getHtmlTagAttributes();
        }
        return ImmutableMap.of();
    }

    private ComponentManager componentManager() {
        if (this.componentManager == null) {
            this.componentManager = (ComponentManager)AdaptTo.notNull((Adaptable)this.resolver, ComponentManager.class);
        }
        return this.componentManager;
    }

    private Item createNewAreaItem() {
        String style = null;
        CssBuilder css = new CssBuilder();
        css.add(NEWAREA_CSS_CLASS_NAME);
        if (this.generateDefaultCss) {
            style = NEWAREA_STYLE;
            css.add(SECTION_DEFAULT_CLASS_NAME);
        }
        css.add(this.newAreaCss);
        String newAreaElementName = StringUtils.defaultString((String)this.paragraphElementName, (String)DEFAULT_ELEMENT_NAME);
        String newAreaResourceType = this.getNewAreaResourceType(this.componentContext.getComponent().getPath());
        return new Item(NEWAREA_RESOURCE_PATH, newAreaResourceType, newAreaElementName, style, css.build(), true);
    }

    private String getNewAreaResourceType(String componentPath) {
        Resource componentResource = this.resolver.getResource(componentPath);
        if (componentResource != null) {
            if (componentResource.getChild(NEWAREA_CHILD_NAME) != null) {
                return componentPath + "/" + NEWAREA_CHILD_NAME;
            }
            String resourceSuperType = componentResource.getResourceSuperType();
            if (StringUtils.isNotEmpty((CharSequence)resourceSuperType)) {
                return this.getNewAreaResourceType(resourceSuperType);
            }
        }
        return FALLBACK_NEWAREA_RESOURCE_TYPE;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public String getWrapperElementName() {
        return StringUtils.defaultString((String)this.wrapperElementName, (String)DEFAULT_ELEMENT_NAME);
    }

    public String getWrapperCss() {
        return this.wrapperCss;
    }

    public boolean isWrapperElement() {
        return StringUtils.isNotBlank((CharSequence)this.wrapperElementName);
    }

    public static final class Item {
        private final String resourcePath;
        private final String resourceType;
        private final String elementName;
        private final String style;
        private final String cssClassName;
        private final boolean newArea;

        Item(String resourcePath, String resourceType, String elementName, String style, String cssClassName, boolean newArea) {
            this.resourcePath = resourcePath;
            this.resourceType = resourceType;
            this.elementName = elementName;
            this.style = style;
            this.cssClassName = cssClassName;
            this.newArea = newArea;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getStyle() {
            return this.style;
        }

        public String getCssClassName() {
            return this.cssClassName;
        }

        public boolean isNewArea() {
            return this.newArea;
        }
    }
}

