/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.galenium.example;

import io.wcm.qa.galenium.device.TestDevice;
import io.wcm.qa.galenium.example.selectors.common.Page;
import io.wcm.qa.galenium.exceptions.GaleniumException;
import io.wcm.qa.galenium.interaction.Aem;
import io.wcm.qa.galenium.interaction.Element;
import io.wcm.qa.galenium.interaction.Wait;
import io.wcm.qa.galenium.selectors.base.Selector;
import io.wcm.qa.galenium.testcase.AbstractGaleniumBase;

public abstract class AbstractExampleBase
extends AbstractGaleniumBase {
    private static final String ROOT_PACKAGE_FOR_TESTS = "io.wcm.qa";
    private static final int CUTOFF_MOBILE_WIDTH = 601;
    protected static final String PATH_TO_CONFERENCE_PAGE = "/en/conference.html";
    protected static final String PATH_TO_HOMEPAGE = "/en.html";

    public AbstractExampleBase(TestDevice testDevice) {
        super(testDevice);
        this.getNameDifferences().setRootPackage(ROOT_PACKAGE_FOR_TESTS);
    }

    private void navShouldBeVisible() {
        Element.findOrFail((Selector)Page.NAVIGATION);
    }

    protected void clickConferenceNavLink() {
        Page.Navigation.LINK_TO_CONFERENCE.click();
    }

    protected abstract String getRelativePath();

    protected String getStartUrl() {
        return this.getBaseUrl() + this.getRelativePath();
    }

    protected boolean isMobile() {
        return this.getDevice().getScreenSize().getWidth() < 601;
    }

    protected void loadStartUrl() {
        if (Aem.loginToAuthor((String)this.getStartUrl())) {
            this.getLogger().debug("loaded start URL: " + this.getStartUrl());
            return;
        }
        throw new GaleniumException("could not login to author when loading start URL.");
    }

    protected void openNav() {
        this.navShouldBeVisible();
        if (this.isMobile()) {
            Page.Navigation.MENU_OPENER.click();
            Wait.forVisibility((Selector)Page.Navigation.LINK_TO_CONFERENCE);
        }
    }
}

