/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.galenium.example.pageobjects;

import io.wcm.qa.galenium.example.pageobjects.LinkItem;
import io.wcm.qa.galenium.selectors.base.Selector;
import io.wcm.qa.galenium.selectors.base.SelectorFactory;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

public class NavigationTopLevelEntry
extends LinkItem {
    private static final Selector SELECTOR_MAIN_LINK = SelectorFactory.fromCss((String)"a.navlink-main");
    private static final Selector SELECTOR_SUB_LINKS = SelectorFactory.fromCss((String)"ul > li > a");
    private List<LinkItem> subEntries;

    NavigationTopLevelEntry(WebElement webElement) {
        super(webElement);
    }

    @Override
    public void click() {
        this.getNavLink().click();
    }

    public List<LinkItem> getNavigationSubEntries() {
        if (this.subEntries == null) {
            this.subEntries = new ArrayList<LinkItem>();
            List elements = this.getWebElement().findElements(SELECTOR_SUB_LINKS.asBy());
            for (WebElement webElement : elements) {
                this.subEntries.add(new LinkItem(webElement));
            }
        }
        return this.subEntries;
    }

    @Override
    public String getTitle() {
        return this.getNavLink().getText();
    }

    private WebElement getNavLink() {
        return this.getWebElement().findElement(SELECTOR_MAIN_LINK.asBy());
    }
}

