/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.galenium.example.pageobjects;

import io.wcm.qa.galenium.example.pageobjects.AbstractWebDriverPageObject;
import io.wcm.qa.galenium.example.pageobjects.LinkItem;
import io.wcm.qa.galenium.selectors.base.Selector;
import io.wcm.qa.galenium.selectors.base.SelectorFactory;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

public class Stage
extends AbstractWebDriverPageObject {
    private static final Selector SELECTOR_STAGE = SelectorFactory.fromCss((String)"#stage");
    private static final Selector SELECTOR_STAGE_CTA_LINKS = SelectorFactory.fromCss((String)"div.stage-cta-box > div.stageheaderLinkItem a.stage-cta");
    private static final Selector SELECTOR_STAGE_DESCRIPTION = SelectorFactory.fromCss((String)"div.stage-overlay div.stage-title > p");
    private static final Selector SELECTOR_STAGE_HEADLINE = SelectorFactory.fromCss((String)"div.stage-title > h2");
    private List<LinkItem> ctaLinks;
    private WebElement stage;

    public List<LinkItem> getCtaLinks() {
        if (this.ctaLinks == null) {
            this.ctaLinks = new ArrayList<LinkItem>();
            List elements = this.getStage().findElements(SELECTOR_STAGE_CTA_LINKS.asBy());
            for (WebElement webElement : elements) {
                this.ctaLinks.add(new LinkItem(webElement));
            }
        }
        return this.ctaLinks;
    }

    public String getDescription() {
        return this.getStage().findElement(SELECTOR_STAGE_DESCRIPTION.asBy()).getText();
    }

    public String getTitle() {
        return this.getStage().findElement(SELECTOR_STAGE_HEADLINE.asBy()).getText();
    }

    private WebElement getStage() {
        if (this.stage == null) {
            this.stage = this.getDriver().findElement(SELECTOR_STAGE.asBy());
        }
        return this.stage;
    }
}

