/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.glnm.interaction;

import io.wcm.qa.glnm.exceptions.GaleniumException;
import io.wcm.qa.glnm.reporting.GaleniumReportUtil;
import io.wcm.qa.glnm.sampling.CanCache;
import io.wcm.qa.glnm.selectors.base.Selector;
import io.wcm.qa.glnm.util.GaleniumContext;
import io.wcm.qa.glnm.verification.base.Verifiable;
import io.wcm.qa.glnm.verification.base.Verification;
import io.wcm.qa.glnm.verification.element.InvisibilityVerification;
import io.wcm.qa.glnm.verification.element.TextVerification;
import io.wcm.qa.glnm.verification.element.VisibilityVerification;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class Wait {
    private static final int DEFAULT_NUMBER_OF_POLLS_PER_CALL = 5;
    private static final int DEFAULT_TIMEOUT = 1;

    private Wait() {
    }

    public static void forCondition(Verifiable condition) {
        int timeOut = 1;
        Wait.forCondition(condition, timeOut);
    }

    public static void forCondition(Verifiable condition, int timeout) {
        int pollingInterval = Wait.getPollingIntervalForTimeout(timeout);
        Wait.forCondition(condition, timeout, pollingInterval);
    }

    public static void forCondition(Verifiable condition, int timeOut, int pollingInterval) {
        WebDriverWait wait = Wait.getWait(timeOut, pollingInterval);
        VerifiableExpectedCondition verifiableCondition = new VerifiableExpectedCondition(condition);
        try {
            wait.until((Function)verifiableCondition);
        }
        catch (TimeoutException ex) {
            if (verifiableCondition.isVerification()) {
                Verification verification = (Verification)verifiableCondition.getVerifiable();
                throw new GaleniumException(verification.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public static void forDomReady() {
        Wait.forDomReady(1);
    }

    public static void forDomReady(int timeOutInSeconds) {
        WebDriverWait wait = Wait.getWait(timeOutInSeconds);
        wait.until(driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete"));
    }

    public static void forInvisibility(Selector selector) {
        Wait.forCondition((Verifiable)new InvisibilityVerification(selector), 1);
    }

    public static void forInvisibility(Selector selector, int timeout) {
        Wait.forCondition((Verifiable)new InvisibilityVerification(selector), timeout);
    }

    public static void forText(Selector selector) {
        Wait.forText(selector, null, 1);
    }

    public static void forText(Selector selector, int timeout) {
        Wait.forText(selector, null, timeout);
    }

    public static void forText(Selector selector, String text) {
        Wait.forText(selector, text, 1);
    }

    public static void forText(Selector selector, String text, int timeout) {
        Wait.forCondition((Verifiable)new TextVerification(selector, text), timeout);
    }

    public static void forUrl(String url) {
        Wait.forUrl(url, 1);
    }

    public static void forUrl(String url, int timeOutInSeconds) {
        GaleniumReportUtil.getLogger().trace("waiting for URL: '" + url + "'");
        WebDriverWait wait = Wait.getWait(timeOutInSeconds);
        wait.until((Function)ExpectedConditions.urlToBe((String)url));
        GaleniumReportUtil.getLogger().trace("found URL: '" + url + "'");
    }

    public static void forVisibility(Selector selector) {
        Wait.forCondition((Verifiable)new VisibilityVerification(selector), 1);
    }

    public static void forVisibility(Selector selector, int timeout) {
        Wait.forCondition((Verifiable)new VisibilityVerification(selector), timeout);
    }

    private static int getPollingIntervalForTimeout(int timeoutInSeconds) {
        int timeoutInMillis = timeoutInSeconds * 1000;
        return timeoutInMillis / 5;
    }

    private static WebDriverWait getWait(int timeOutInSeconds) {
        return Wait.getWait(timeOutInSeconds, Wait.getPollingIntervalForTimeout(timeOutInSeconds));
    }

    private static WebDriverWait getWait(int timeOutInSeconds, int pollingInterval) {
        return new WebDriverWait(GaleniumContext.getDriver(), (long)timeOutInSeconds, (long)pollingInterval);
    }

    private static final class VerifiableExpectedCondition
    implements Function<WebDriver, Boolean> {
        private final Verifiable condition;

        private VerifiableExpectedCondition(Verifiable condition) {
            this.condition = condition;
            if (condition instanceof CanCache) {
                CanCache verification = (CanCache)condition;
                GaleniumReportUtil.getLogger().debug("disable caching for '" + verification + "' verification");
                verification.setCaching(false);
                if (verification.isCaching()) {
                    GaleniumReportUtil.getLogger().warn("waiting for a caching verification is not a sensible thing to do. Offending verification: '" + verification + "'");
                }
            }
        }

        @Override
        public Boolean apply(WebDriver arg0) {
            return this.condition.verify();
        }

        public Verifiable getVerifiable() {
            return this.condition;
        }

        public boolean isVerification() {
            return this.getVerifiable() instanceof Verification;
        }

        public String toString() {
            return super.toString() + ": '" + this.condition + "'";
        }
    }
}

