/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.glnm.interaction;

import io.wcm.qa.glnm.exceptions.GaleniumException;
import io.wcm.qa.glnm.sampling.CanCache;
import io.wcm.qa.glnm.selectors.base.Selector;
import io.wcm.qa.glnm.verification.base.Verifiable;
import io.wcm.qa.glnm.verification.base.Verification;
import io.wcm.qa.glnm.verification.base.VerificationBase;
import io.wcm.qa.glnm.verification.element.InvisibilityVerification;
import io.wcm.qa.glnm.verification.element.TextVerification;
import io.wcm.qa.glnm.verification.element.VisibilityVerification;
import io.wcm.qa.glnm.webdriver.WebDriverManagement;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Wait {
    private static final int DEFAULT_TIMEOUT = 1;
    private static final Logger LOG = LoggerFactory.getLogger(Wait.class);

    private Wait() {
    }

    public static void forCondition(Verifiable condition) {
        Wait.forCondition(condition, 1);
    }

    public static void forCondition(Verifiable condition, int timeout) {
        Wait.forCondition(condition, WebDriverManagement.getWait((int)timeout));
    }

    public static void forCondition(Verifiable condition, int timeOut, int pollingInterval) {
        Wait.forCondition(condition, WebDriverManagement.getWait((int)timeOut, (int)pollingInterval));
    }

    public static void forDomReady() {
        Wait.forDomReady(1);
    }

    public static void forDomReady(int timeOutInSeconds) {
        WebDriverWait wait = WebDriverManagement.getWait((int)timeOutInSeconds);
        wait.until(driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete"));
    }

    public static void forInvisibility(Selector selector) {
        Wait.forCondition((Verifiable)new InvisibilityVerification(selector), 1);
    }

    public static void forInvisibility(Selector selector, int timeout) {
        Wait.forCondition((Verifiable)new InvisibilityVerification(selector), timeout);
    }

    public static void forText(Selector selector) {
        Wait.forText(selector, null, 1);
    }

    public static void forText(Selector selector, int timeout) {
        Wait.forText(selector, null, timeout);
    }

    public static void forText(Selector selector, String text) {
        Wait.forText(selector, text, 1);
    }

    public static void forText(Selector selector, String text, int timeout) {
        Wait.forCondition((Verifiable)new TextVerification(selector, text), timeout);
    }

    public static void forUrl(String url) {
        Wait.forUrl(url, 1);
    }

    public static void forUrl(String url, int timeOutInSeconds) {
        LOG.trace("waiting for URL: '" + url + "'");
        WebDriverWait wait = WebDriverManagement.getWait((int)timeOutInSeconds);
        wait.until((Function)ExpectedConditions.urlToBe((String)url));
        LOG.trace("found URL: '" + url + "'");
    }

    public static void forVisibility(Selector selector) {
        Wait.forCondition((Verifiable)new VisibilityVerification(selector), 1);
    }

    public static void forVisibility(Selector selector, int timeout) {
        Wait.forCondition((Verifiable)new VisibilityVerification(selector), timeout);
    }

    private static void forCondition(Verifiable condition, WebDriverWait wait) {
        VerifiableExpectedCondition verifiableCondition = new VerifiableExpectedCondition(condition);
        try {
            wait.until((Function)verifiableCondition);
        }
        catch (TimeoutException ex) {
            if (verifiableCondition.isVerification()) {
                Verification verification = (Verification)verifiableCondition.getVerifiable();
                if (verification instanceof VerificationBase && ((VerificationBase)verification).isVerified().booleanValue()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Time out, but verification not failing: " + verification.getMessage());
                    }
                    return;
                }
                throw new GaleniumException(verification.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    private static final class VerifiableExpectedCondition
    implements Function<WebDriver, Boolean> {
        private final Verifiable condition;

        private VerifiableExpectedCondition(Verifiable condition) {
            this.condition = condition;
            if (condition instanceof CanCache) {
                CanCache verification = (CanCache)condition;
                LOG.debug("disable caching for '" + verification + "' verification");
                verification.setCaching(false);
                if (verification.isCaching()) {
                    LOG.warn("waiting for a caching verification is not a sensible thing to do. Offending verification: '" + verification + "'");
                }
            }
        }

        @Override
        public Boolean apply(WebDriver arg0) {
            return this.condition.verify();
        }

        public Verifiable getVerifiable() {
            return this.condition;
        }

        public boolean isVerification() {
            return this.getVerifiable() instanceof Verification;
        }

        public String toString() {
            return super.toString() + ": '" + this.condition + "'";
        }
    }
}

