/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.glnm.interaction.aem.author;

import io.wcm.qa.glnm.configuration.GaleniumConfiguration;
import io.wcm.qa.glnm.exceptions.GaleniumException;
import io.wcm.qa.glnm.interaction.Browser;
import io.wcm.qa.glnm.interaction.Element;
import io.wcm.qa.glnm.interaction.FormElement;
import io.wcm.qa.glnm.interaction.Wait;
import io.wcm.qa.glnm.selectors.base.Selector;
import io.wcm.qa.glnm.selectors.base.SelectorFactory;
import io.wcm.qa.glnm.util.GaleniumContext;
import io.wcm.qa.glnm.util.HttpUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorLogin {
    private static final Selector DIV_LOGIN_BOX = SelectorFactory.fromCss((String)"div#login-box");
    private static final Logger LOG = LoggerFactory.getLogger(AuthorLogin.class);
    private static final String PARAM_NAME_CHARSET = "_charset_";
    private static final String PARAM_NAME_PASSWORD = "j_password";
    private static final String PARAM_NAME_USERNAME = "j_username";
    private static final String PARAM_NAME_VALIDATE = "j_validate";
    private static final String PARAM_VALUE_CHARSET = "utf-8";
    private static final String PARAM_VALUE_VALIDATE = "true";
    private static final String RELATIVE_PATH_LOGIN_FORM_POST = "/libs/granite/core/content/login.html/j_security_check";
    private static final Selector SELECTOR_AUTHOR_INPUT_PASSWORD = SelectorFactory.fromCss((String)"#password");
    private static final Selector SELECTOR_AUTHOR_INPUT_USERNAME = SelectorFactory.fromCss((String)"#username");
    private static final Selector SELECTOR_AUTHOR_LOGIN_BUTTON = SelectorFactory.fromCss((String)"#submit-button");

    private AuthorLogin() {
    }

    public static boolean isAuthorLogin() {
        return Element.isVisible((Selector)DIV_LOGIN_BOX);
    }

    public static boolean loginToAuthor() {
        LOG.debug("using credentials from configuration.");
        return AuthorLogin.loginToAuthorViaBrowser(GaleniumConfiguration.getAuthorUser(), GaleniumConfiguration.getAuthorPass());
    }

    public static boolean loginToAuthor(String targetUrl) {
        LOG.debug("using credentials from configuration.");
        return AuthorLogin.loginToAuthor(targetUrl, GaleniumConfiguration.getAuthorUser(), GaleniumConfiguration.getAuthorPass());
    }

    public static boolean loginToAuthor(String targetUrl, String authorUser, String authorPass) {
        return AuthorLogin.loginToAuthor(targetUrl, targetUrl, authorUser, authorPass);
    }

    public static boolean loginToAuthor(String initialUrl, String finalUrl, String authorUser, String authorPass) {
        Browser.load((String)initialUrl);
        if (AuthorLogin.isAuthorLogin()) {
            try {
                AuthorLogin.loginToAuthorViaBrowser(authorUser, authorPass);
                Wait.forUrl(finalUrl, 5);
                return true;
            }
            catch (WebDriverException ex) {
                WebDriver driver = GaleniumContext.getDriver();
                String actualResult = driver == null ? "driver is null in this context" : driver.getCurrentUrl();
                LOG.warn("author login not successful, when waiting for '" + finalUrl + "' got '" + actualResult + "'");
            }
        } else {
            LOG.debug("skipping author login, because not on login page.");
        }
        return false;
    }

    public static boolean loginToAuthorViaHttp(String authorBaseUrl, String authorUser, String authorPass) {
        URL url;
        try {
            url = new URL(authorBaseUrl + RELATIVE_PATH_LOGIN_FORM_POST);
        }
        catch (MalformedURLException ex) {
            throw new GaleniumException("could not parse author base URL");
        }
        Map<String, String> paramMap = AuthorLogin.getCredentialParamsForPost(authorUser, authorPass);
        HttpResponse response = HttpUtil.postForm((URL)url, paramMap);
        AuthorLogin.logResponse(response);
        return response.getStatusLine().getStatusCode() == 200;
    }

    private static Map<String, String> getCredentialParamsForPost(String authorUser, String authorPass) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(PARAM_NAME_USERNAME, authorUser);
        paramMap.put(PARAM_NAME_PASSWORD, authorPass);
        paramMap.put(PARAM_NAME_VALIDATE, PARAM_VALUE_VALIDATE);
        paramMap.put(PARAM_NAME_CHARSET, PARAM_VALUE_CHARSET);
        return paramMap;
    }

    private static boolean loginToAuthorViaBrowser(String authorUser, String authorPass) {
        if (AuthorLogin.isAuthorLogin()) {
            LOG.debug("Attempting login in to author instance");
            FormElement.clearAndEnterText((Selector)SELECTOR_AUTHOR_INPUT_USERNAME, (String)authorUser);
            FormElement.clearAndEnterText((Selector)SELECTOR_AUTHOR_INPUT_PASSWORD, (String)authorPass);
            Element.click((Selector)SELECTOR_AUTHOR_LOGIN_BUTTON);
            LOG.info("Logging in to author instance.");
            return true;
        }
        LOG.debug("Not logging in to author instance.");
        return false;
    }

    private static void logResponse(HttpResponse response) {
        Header[] allHeaders = response.getAllHeaders();
        LOG.debug("status: " + response.getStatusLine().getStatusCode() + "(" + response.getStatusLine().getReasonPhrase() + ")");
        for (Header header : allHeaders) {
            LOG.debug("'" + header.getName() + "': '" + header.getValue() + "'");
        }
    }
}

