/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.galenium.selectors;

import com.galenframework.specs.page.CorrectionsRect;
import com.galenframework.specs.page.Locator;

public class LocatorCorrectionsWrapper
extends Locator {
    private CorrectionsRect additionalCorrections;

    public LocatorCorrectionsWrapper(Locator locator, CorrectionsRect corrections) {
        super(locator.getLocatorType(), locator.getLocatorValue(), locator.getIndex());
        this.setParent(locator.getParent());
        this.setAdditionalCorrections(corrections);
    }

    public CorrectionsRect getAdditionalCorrections() {
        return this.additionalCorrections;
    }

    public CorrectionsRect getCorrections() {
        return this.combinedCorrections(super.getCorrections(), this.getAdditionalCorrections());
    }

    public void setAdditionalCorrections(CorrectionsRect additionalCorrections) {
        this.additionalCorrections = additionalCorrections;
    }

    private CorrectionsRect.Correction combinedCorrection(CorrectionsRect.Correction c1, CorrectionsRect.Correction c2) {
        return new CombinedCorrection(c1, c2);
    }

    private CorrectionsRect combinedCorrections(CorrectionsRect cr1, CorrectionsRect cr2) {
        if (cr1 == null) {
            return cr2;
        }
        if (cr2 == null) {
            return cr1;
        }
        CorrectionsRect.Correction left = this.combinedCorrection(cr1.getLeft(), cr2.getLeft());
        CorrectionsRect.Correction top = this.combinedCorrection(cr1.getTop(), cr2.getTop());
        CorrectionsRect.Correction width = this.combinedCorrection(cr1.getWidth(), cr2.getWidth());
        CorrectionsRect.Correction height = this.combinedCorrection(cr1.getHeight(), cr2.getHeight());
        return new CorrectionsRect(left, top, width, height);
    }

    private class CombinedCorrection
    extends CorrectionsRect.Correction {
        private CorrectionsRect.Correction additionalCorrection;

        CombinedCorrection(CorrectionsRect.Correction original, CorrectionsRect.Correction additional) {
            super(original.getValue(), original.getType());
            this.additionalCorrection = additional;
        }

        public int correct(int oldValue) {
            int correctedValue = super.correct(oldValue);
            return this.additionalCorrection.correct(correctedValue);
        }
    }
}

