/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.galenium.selectors.base;

import com.galenframework.specs.page.Locator;
import io.wcm.qa.galenium.selectors.base.AbstractSelectorBase;
import io.wcm.qa.galenium.selectors.base.NestedSelector;
import io.wcm.qa.galenium.selectors.base.Selector;
import io.wcm.qa.galenium.selectors.base.SelectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.openqa.selenium.By;

public class AbstractNestedSelectorBase
extends AbstractSelectorBase
implements NestedSelector {
    private Selector absolute;
    private Collection<NestedSelector> children;
    private NestedSelector parent;
    private Selector relative;

    public void addChild(NestedSelector child) {
        this.getChildren().add(child);
    }

    @Override
    public Selector asAbsolute() {
        if (this.getAbsolute() == null) {
            this.setAbsolute(this.getClone());
        }
        return this.getAbsolute();
    }

    @Override
    public By asBy() {
        return this.asAbsolute().asBy();
    }

    @Override
    public Locator asLocator() {
        return this.asAbsolute().asLocator();
    }

    @Override
    public Selector asRelative() {
        if (this.getRelative() == null) {
            this.setRelative(this.getClone());
        }
        return this.getRelative();
    }

    @Override
    public String asString() {
        return this.asAbsolute().asString();
    }

    @Override
    public String elementName() {
        return this.asAbsolute().elementName();
    }

    @Override
    public Collection<NestedSelector> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<NestedSelector>();
        }
        return this.children;
    }

    @Override
    public NestedSelector getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void setParent(NestedSelector parent) {
        this.parent = parent;
        this.parentChanged(parent);
    }

    private Selector getClone() {
        return SelectorFactory.fromValues(this.getName(), this.getString(), this.getBy(), this.getLocator());
    }

    protected Selector getAbsolute() {
        return this.absolute;
    }

    protected Selector getRelative() {
        return this.relative;
    }

    protected void parentChanged(NestedSelector newParent) {
        if (newParent != null) {
            this.setAbsolute(SelectorFactory.relativeToAbsolute((Selector)newParent, this.asRelative()));
        } else {
            this.setAbsolute(null);
        }
    }

    protected void setAbsolute(Selector absolute) {
        this.absolute = absolute;
    }

    protected void setChildren(Collection<NestedSelector> children) {
        this.children = children;
    }

    protected void setRelative(Selector relative) {
        this.relative = relative;
    }
}

