/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.qa.galenium.selectors.base;

import com.galenframework.specs.page.Locator;
import io.wcm.qa.galenium.exceptions.GaleniumException;
import io.wcm.qa.galenium.selectors.FixedValueNestedSelector;
import io.wcm.qa.galenium.selectors.FixedValueSelector;
import io.wcm.qa.galenium.selectors.SelectorFromLocator;
import io.wcm.qa.galenium.selectors.SelectorFromString;
import io.wcm.qa.galenium.selectors.base.NestedSelector;
import io.wcm.qa.galenium.selectors.base.Selector;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public final class SelectorFactory {
    private SelectorFactory() {
    }

    public static Selector fromCss(String selectorString) {
        return new SelectorFromString(selectorString);
    }

    public static Selector fromCss(String elementName, String selectorString) {
        SelectorFromString selector = new SelectorFromString(selectorString);
        selector.setName(elementName);
        return selector;
    }

    public static SelectorFromLocator fromLocator(Locator locator) {
        SelectorFactory.checkLocator(locator);
        return new SelectorFromLocator(locator);
    }

    public static SelectorFromLocator fromLocator(String elementName, Locator locator) {
        SelectorFactory.checkLocator(locator);
        return new SelectorFromLocator(elementName, locator);
    }

    public static NestedSelector fromSelector(NestedSelector sourceSelector) {
        return new FixedValueNestedSelector(sourceSelector);
    }

    public static Selector fromSelector(Selector sourceSelector) {
        return new FixedValueSelector(sourceSelector);
    }

    public static Selector fromValues(String elementName, String css, By by, Locator locator) {
        return new FixedValueSelector(elementName, css, by, locator);
    }

    public static NestedSelector fromValues(String elementName, String css, By by, Locator locator, Selector absolute, Selector relative, NestedSelector parent, Collection<NestedSelector> children) {
        return new FixedValueNestedSelector(elementName, css, by, locator, absolute, relative, parent, children);
    }

    public static Selector relativeToAbsolute(Selector parent, Selector relativeSelector) {
        return SelectorFactory.relativeToAbsolute(parent, relativeSelector.elementName(), relativeSelector.asString());
    }

    public static Selector relativeToAbsolute(Selector parent, String relativeCssSelector) {
        return SelectorFactory.relativeToAbsolute(parent, "child", relativeCssSelector);
    }

    public static Selector relativeToAbsolute(Selector parent, String childName, String relativeCssSelector) {
        String selectorString = parent.asString() + " " + relativeCssSelector;
        String parentName = parent.elementName();
        String elementName = StringUtils.startsWith((CharSequence)childName, (CharSequence)parentName) ? childName : parentName + "." + childName;
        return SelectorFactory.fromCss(elementName, selectorString);
    }

    private static void checkLocator(Locator locator) {
        switch (locator.getLocatorType()) {
            case "css": {
                return;
            }
            case "id": {
                locator.setLocatorType("css");
                locator.setLocatorValue("#" + locator.getLocatorValue());
                return;
            }
        }
        throw new GaleniumException("unsupported locator type: '" + locator.getLocatorType() + "'");
    }
}

