/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.samples.core.business.navigation.impl;

import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.url.ui.SiteRoot;
import io.wcm.samples.core.business.navigation.NavigationManager;
import io.wcm.samples.core.business.navigation.NavigationPageItem;
import io.wcm.sling.models.annotations.AemObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={NavigationManager.class})
public class NavigationManagerImpl
implements NavigationManager {
    @Self
    private SiteRoot siteRoot;
    @Self
    private LinkHandler linkHandler;
    @AemObject
    private Page currentPage;
    private static final String FOOTERNAV_RELATIVE_PATH = "/tools/navigation/footernav";

    @Override
    public NavigationPageItem getMainNavigation(int maxLevels) {
        Page siteRootPage = this.siteRoot.getRootPage();
        NavigationPageItem rootItem = this.createLinkableItem(siteRootPage);
        if (maxLevels > 0) {
            rootItem.setChildren(this.createChildItemsRecursively(siteRootPage, new ValidLinkableItemCreator(), 1, maxLevels));
        }
        return rootItem;
    }

    @Override
    public NavigationPageItem getFooterNavigation() {
        Page footerNavRoot = this.siteRoot.getRelativePage(FOOTERNAV_RELATIVE_PATH);
        if (footerNavRoot != null) {
            return this.getFooterNavigationSpecific(footerNavRoot);
        }
        return this.getFooterNavigationDerivedFromMainNav(this.siteRoot.getRootPage());
    }

    private NavigationPageItem getFooterNavigationSpecific(Page footerNavRoot) {
        NavigationPageItem rootItem = this.createStructureItem(footerNavRoot);
        rootItem.setChildren(this.createChildItems(footerNavRoot, new ItemCreator(){

            @Override
            public NavigationPageItem create(Page pPage) {
                NavigationPageItem columnItem = NavigationManagerImpl.this.createStructureItem(pPage);
                columnItem.setChildren(NavigationManagerImpl.this.createChildItems(pPage, new ValidLinkableItemCreator()));
                if (columnItem.getChildren().isEmpty()) {
                    return null;
                }
                return columnItem;
            }
        }));
        return rootItem;
    }

    private NavigationPageItem getFooterNavigationDerivedFromMainNav(Page siteRootPage) {
        NavigationPageItem rootItem = this.createStructureItem(siteRootPage);
        rootItem.setChildren(this.createChildItems(siteRootPage, new ItemCreator(){

            @Override
            public NavigationPageItem create(Page pPage) {
                NavigationPageItem columnItem = NavigationManagerImpl.this.createStructureItem(pPage);
                ArrayList<NavigationPageItem> linkItems = new ArrayList<NavigationPageItem>();
                NavigationPageItem mainnavLinkItem = NavigationManagerImpl.this.createLinkableItem(pPage);
                if (mainnavLinkItem.getLink().isValid()) {
                    linkItems.add(mainnavLinkItem);
                }
                linkItems.addAll(NavigationManagerImpl.this.createChildItems(pPage, new ValidLinkableItemCreator()));
                columnItem.setChildren(linkItems);
                if (columnItem.getChildren().isEmpty()) {
                    return null;
                }
                return columnItem;
            }
        }));
        return rootItem;
    }

    private NavigationPageItem createStructureItem(Page page) {
        String title = this.getItemTitle(page);
        return new NavigationPageItem(title);
    }

    private NavigationPageItem createLinkableItem(Page page) {
        String title = this.getItemTitle(page);
        boolean isCurrentPage = StringUtils.equals((CharSequence)page.getPath(), (CharSequence)this.currentPage.getPath());
        Link link = this.linkHandler.get(page).build();
        return new NavigationPageItem(title, isCurrentPage, link);
    }

    private String getItemTitle(Page page) {
        return StringUtils.defaultString((String)page.getNavigationTitle(), (String)page.getTitle());
    }

    private List<NavigationPageItem> createChildItems(Page parentPage, ItemCreator itemCreator) {
        ArrayList<NavigationPageItem> items = new ArrayList<NavigationPageItem>();
        Iterator childPages = parentPage.listChildren((Filter)new PageFilter(false, false));
        while (childPages.hasNext()) {
            Page childPage = (Page)childPages.next();
            NavigationPageItem item = itemCreator.create(childPage);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private List<NavigationPageItem> createChildItemsRecursively(Page parentPage, final ItemCreator itemCreator, final int level, final int maxLevels) {
        return this.createChildItems(parentPage, new ItemCreator(){

            @Override
            public NavigationPageItem create(Page pPage) {
                NavigationPageItem item = itemCreator.create(pPage);
                if (item != null && level < maxLevels) {
                    item.setChildren(NavigationManagerImpl.this.createChildItemsRecursively(pPage, itemCreator, level + 1, maxLevels));
                }
                return item;
            }
        });
    }

    private class ValidLinkableItemCreator
    implements ItemCreator {
        private ValidLinkableItemCreator() {
        }

        @Override
        public NavigationPageItem create(Page page) {
            NavigationPageItem item = NavigationManagerImpl.this.createLinkableItem(page);
            if (item.getLink().isValid()) {
                return item;
            }
            return null;
        }
    }

    private static interface ItemCreator {
        public NavigationPageItem create(Page var1);
    }
}

