/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.samples.core.controller.common;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.url.ui.SiteRoot;
import io.wcm.samples.core.config.AppTemplate;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.util.Template;
import io.wcm.wcm.commons.util.TemplatePathInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class})
public class PageTitle {
    @AemObject
    private Page currentPage;
    @Self
    private SiteRoot siteRoot;

    public String getRecursivePageTitle() {
        return this.getRecursivePageTitle(this.currentPage);
    }

    private String getRecursivePageTitle(Page page) {
        if (this.siteRoot.isRootPage(page)) {
            return StringUtils.defaultString((String)page.getPageTitle(), (String)page.getTitle());
        }
        if (Template.is((Page)page, (TemplatePathInfo[])new TemplatePathInfo[]{AppTemplate.ADMIN_STRUCTURE_ELEMENT})) {
            return this.getRecursivePageTitle(page.getParent());
        }
        return StringUtils.defaultString((String)page.getPageTitle(), (String)page.getTitle()) + " - " + this.getRecursivePageTitle(page.getParent());
    }

    public String getSiteRootPageTitle() {
        return this.siteRoot.getRootPage().getPageTitle();
    }
}

