/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.samples.core.controller.navigation;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.url.ui.SiteRoot;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class})
public class SiteRootRelativePageLink {
    private Link link;
    private String title;

    @Inject
    public SiteRootRelativePageLink(@Self SiteRoot siteRoot, @Self LinkHandler linkHandler, @RequestAttribute(name="relativePath", optional=true) String relativePath, @RequestAttribute(name="titleType", optional=true) @Default(values={"navigationTitle"}) String titleType) {
        Page page = StringUtils.isNotEmpty((CharSequence)relativePath) ? siteRoot.getRelativePage(relativePath) : siteRoot.getRootPage();
        if (page != null) {
            this.link = linkHandler.get(page).build();
            switch (titleType) {
                case "pageTitle": {
                    this.title = StringUtils.defaultString((String)page.getPageTitle(), (String)page.getTitle());
                    break;
                }
                default: {
                    this.title = StringUtils.defaultString((String)page.getNavigationTitle(), (String)page.getTitle());
                }
            }
        }
    }

    public Link getMetadata() {
        return this.link;
    }

    public boolean isValid() {
        return this.link.isValid();
    }

    public Map<String, String> getAttributes() {
        return this.link.getAnchorAttributes();
    }

    public String getTitle() {
        return this.title;
    }
}

