/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.samples.core.controller.resource;

import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaHandler;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class ResourceMedia {
    @RequestAttribute
    private String mediaFormat;
    @RequestAttribute(optional=true)
    private String cssClass;
    @Self
    private MediaHandler mediaHandler;
    @SlingObject
    private Resource resource;
    private Media media;

    @PostConstruct
    private void activate() {
        this.media = this.mediaHandler.get(this.resource, new MediaArgs(new String[]{this.mediaFormat})).build();
        if (this.media.isValid() && this.media.getElement() != null) {
            int imageHeight;
            ValueMap props;
            int imageWidth;
            HtmlElement element = this.media.getElement();
            if (StringUtils.isNotEmpty((CharSequence)this.cssClass)) {
                element.addCssClass(this.cssClass);
            }
            if ((imageWidth = ((Integer)(props = this.resource.getValueMap()).get("imageWidth", (Object)0)).intValue()) > 0) {
                element.setAttribute("width", Integer.toString(imageWidth));
            }
            if ((imageHeight = ((Integer)props.get("imageWidth", (Object)0)).intValue()) > 0) {
                element.setAttribute("height", Integer.toString(imageHeight));
            }
        }
    }

    public Media getMetadata() {
        return this.media;
    }

    public boolean isValid() {
        return this.media.isValid();
    }

    public String getMarkup() {
        return this.media.getMarkup();
    }
}

