/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.samples.core.controller.resource;

import io.wcm.handler.richtext.RichTextHandler;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class ResourceRichText {
    @RequestAttribute(optional=true)
    @Default(values={"text"})
    private String propertyName;
    @Self
    private RichTextHandler richTextHandler;
    @SlingObject
    private Resource resource;
    private String markup;

    @PostConstruct
    private void activate() {
        String xhtmlString = (String)this.resource.getValueMap().get(this.propertyName, String.class);
        this.markup = this.richTextHandler.get(xhtmlString).buildMarkup();
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.getMarkup());
    }

    public String getMarkup() {
        return this.markup;
    }
}

