/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.batch.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.grpc.GrpcClient;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.Assert;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBase;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBatch;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.batch.grpc.BatchObjectConverter;
import io.weaviate.client.v1.batch.model.ObjectGetResponse;
import io.weaviate.client.v1.batch.model.ObjectsBatchRequestBody;
import io.weaviate.client.v1.batch.model.ObjectsGetResponseAO2Result;
import io.weaviate.client.v1.batch.util.ObjectsPath;
import io.weaviate.client.v1.data.Data;
import io.weaviate.client.v1.data.model.WeaviateObject;
import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ObjectsBatcher
extends BaseClient<ObjectGetResponse[]>
implements ClientResult<ObjectGetResponse[]>,
Closeable {
    private final Data data;
    private final ObjectsPath objectsPath;
    private final BatchRetriesConfig batchRetriesConfig;
    private final AutoBatchConfig autoBatchConfig;
    private final boolean autoRunEnabled;
    private final ScheduledExecutorService executorService;
    private final DelayedExecutor<?> delayedExecutor;
    private final List<WeaviateObject> objects;
    private String consistencyLevel;
    private final List<CompletableFuture<Result<ObjectGetResponse[]>>> undoneFutures;
    private final boolean useGRPC;
    private final AccessTokenProvider tokenProvider;
    private final Config config;

    private ObjectsBatcher(HttpClient httpClient, Config config, Data data, ObjectsPath objectsPath, AccessTokenProvider tokenProvider, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig) {
        super(httpClient, config);
        this.config = config;
        this.useGRPC = config.useGRPC();
        this.tokenProvider = tokenProvider;
        this.data = data;
        this.objectsPath = objectsPath;
        this.objects = new ArrayList<WeaviateObject>();
        this.batchRetriesConfig = batchRetriesConfig;
        if (autoBatchConfig != null) {
            this.autoRunEnabled = true;
            this.autoBatchConfig = autoBatchConfig;
            this.executorService = Executors.newScheduledThreadPool(autoBatchConfig.poolSize);
            this.delayedExecutor = new ExecutorServiceDelayedExecutor(this.executorService);
            this.undoneFutures = Collections.synchronizedList(new ArrayList());
        } else {
            this.autoRunEnabled = false;
            this.autoBatchConfig = null;
            this.executorService = null;
            this.delayedExecutor = new SleepDelayedExecutor();
            this.undoneFutures = null;
        }
    }

    public static ObjectsBatcher create(HttpClient httpClient, Config config, Data data, ObjectsPath objectsPath, AccessTokenProvider tokenProvider, BatchRetriesConfig batchRetriesConfig) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        return new ObjectsBatcher(httpClient, config, data, objectsPath, tokenProvider, batchRetriesConfig, null);
    }

    public static ObjectsBatcher createAuto(HttpClient httpClient, Config config, Data data, ObjectsPath objectsPath, AccessTokenProvider tokenProvider, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        Assert.requiredNotNull(autoBatchConfig, "autoBatchConfig");
        return new ObjectsBatcher(httpClient, config, data, objectsPath, tokenProvider, batchRetriesConfig, autoBatchConfig);
    }

    public ObjectsBatcher withObject(WeaviateObject object) {
        return this.withObjects(object);
    }

    public ObjectsBatcher withObjects(WeaviateObject ... objects) {
        this.addMissingIds(objects);
        this.objects.addAll(Arrays.asList(objects));
        this.autoRun();
        return this;
    }

    public ObjectsBatcher withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public Result<ObjectGetResponse[]> run() {
        if (this.autoRunEnabled) {
            this.flush();
            return null;
        }
        if (this.objects.isEmpty()) {
            return new Result<ObjectGetResponse[]>(0, new ObjectGetResponse[0], null);
        }
        List<WeaviateObject> batch = this.extractBatch(this.objects.size());
        return (Result)this.runRecursively(batch, 0, 0, null, this.delayedExecutor);
    }

    public void flush() {
        CompletableFuture[] futures;
        if (!this.autoRunEnabled) {
            this.run();
            return;
        }
        if (!this.objects.isEmpty()) {
            List<WeaviateObject> batch = this.extractBatch(this.objects.size());
            this.runInThread(batch);
        }
        if ((futures = this.undoneFutures.toArray(new CompletableFuture[0])).length == 0) {
            return;
        }
        CompletableFuture.allOf(futures).join();
    }

    @Override
    public void close() {
        if (!this.autoRunEnabled) {
            return;
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(this.autoBatchConfig.awaitTerminationMs, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }

    private void addMissingIds(WeaviateObject[] objects) {
        Arrays.stream(objects).filter(o -> o.getId() == null).forEach(o -> o.setId(UUID.randomUUID().toString()));
    }

    private List<WeaviateObject> extractBatch(int batchSize) {
        ArrayList<WeaviateObject> batch = new ArrayList<WeaviateObject>(batchSize);
        List<WeaviateObject> sublist = this.objects.subList(0, batchSize);
        batch.addAll(sublist);
        sublist.clear();
        return batch;
    }

    private void autoRun() {
        if (!this.autoRunEnabled) {
            return;
        }
        while (this.objects.size() >= this.autoBatchConfig.batchSize) {
            List<WeaviateObject> batch = this.extractBatch(this.autoBatchConfig.batchSize);
            this.runInThread(batch);
        }
    }

    private void runInThread(List<WeaviateObject> batch) {
        CompletionStage future = CompletableFuture.supplyAsync(() -> this.createRunFuture(batch), this.executorService).thenCompose(f -> f);
        if (this.autoBatchConfig.callback != null) {
            future = ((CompletableFuture)future).whenComplete((result, e) -> this.autoBatchConfig.callback.accept(result));
        }
        CompletionStage undoneFuture = future;
        this.undoneFutures.add((CompletableFuture<Result<ObjectGetResponse[]>>)undoneFuture);
        ((CompletableFuture)undoneFuture).whenComplete((arg_0, arg_1) -> this.lambda$runInThread$5((CompletableFuture)undoneFuture, arg_0, arg_1));
    }

    private CompletableFuture<Result<ObjectGetResponse[]>> createRunFuture(List<WeaviateObject> batch) {
        return (CompletableFuture)this.runRecursively(batch, 0, 0, null, this.delayedExecutor);
    }

    private <T> T runRecursively(List<WeaviateObject> batch, int connectionErrorCount, int timeoutErrorCount, List<ObjectGetResponse> combinedSingleResponses, DelayedExecutor<T> delayedExecutor) {
        Result<ObjectGetResponse[]> result;
        Result<ObjectGetResponse[]> result2 = result = this.useGRPC ? this.internalGrpcRun(batch) : this.internalRun(batch);
        if (result.hasErrors()) {
            List<WeaviateErrorMessage> messages = result.getError().getMessages();
            if (!messages.isEmpty()) {
                Throwable throwable = messages.get(0).getThrowable();
                boolean executeAgain = false;
                int delay = 0;
                if (throwable instanceof ConnectException) {
                    if (connectionErrorCount++ < this.batchRetriesConfig.maxConnectionRetries) {
                        executeAgain = true;
                        delay = connectionErrorCount * this.batchRetriesConfig.retriesIntervalMs;
                    }
                } else if (throwable instanceof SocketTimeoutException) {
                    Pair<List<ObjectGetResponse>, List<WeaviateObject>> pair = this.fetchCreatedAndBuildBatchToReRun(batch);
                    combinedSingleResponses = this.combineSingleResponses(combinedSingleResponses, (List)pair.getLeft());
                    batch = (List)pair.getRight();
                    if (ObjectUtils.isNotEmpty((Object)batch) && timeoutErrorCount++ < this.batchRetriesConfig.maxTimeoutRetries) {
                        executeAgain = true;
                        delay = timeoutErrorCount * this.batchRetriesConfig.retriesIntervalMs;
                    }
                }
                if (executeAgain) {
                    int lambdaConnectionErrorCount = connectionErrorCount;
                    int lambdaTimeoutErrorCount = timeoutErrorCount;
                    List lambdaBatch = batch;
                    List<ObjectGetResponse> lambdaCombinedSingleResponses = combinedSingleResponses;
                    return (T)delayedExecutor.delayed(delay, () -> this.runRecursively(lambdaBatch, lambdaConnectionErrorCount, lambdaTimeoutErrorCount, lambdaCombinedSingleResponses, delayedExecutor));
                }
            }
        } else {
            batch = null;
        }
        Result<ObjectGetResponse[]> finalResult = this.createFinalResultFromLastResultAndCombinedSingleResponses(result, combinedSingleResponses, batch);
        return delayedExecutor.now(finalResult);
    }

    private Result<ObjectGetResponse[]> internalRun(List<WeaviateObject> batch) {
        ObjectsBatchRequestBody batchRequest = ObjectsBatchRequestBody.builder().objects(batch.toArray(new WeaviateObject[0])).fields(new String[]{"ALL"}).build();
        String path = this.objectsPath.buildCreate(ObjectsPath.Params.builder().consistencyLevel(this.consistencyLevel).build());
        Response<ObjectGetResponse[]> resp = this.sendPostRequest(path, batchRequest, ObjectGetResponse[].class);
        return new Result<ObjectGetResponse[]>(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<ObjectGetResponse[]> internalGrpcRun(List<WeaviateObject> batch) {
        WeaviateProtoBatch.BatchObjectsReply batchObjectsReply;
        List batchObjects = batch.stream().map(BatchObjectConverter::toBatchObject).collect(Collectors.toList());
        WeaviateProtoBatch.BatchObjectsRequest.Builder batchObjectsRequestBuilder = WeaviateProtoBatch.BatchObjectsRequest.newBuilder();
        batchObjectsRequestBuilder.addAllObjects(batchObjects);
        if (this.consistencyLevel != null) {
            WeaviateProtoBase.ConsistencyLevel cl = WeaviateProtoBase.ConsistencyLevel.CONSISTENCY_LEVEL_ONE;
            if (this.consistencyLevel.equals("ALL")) {
                cl = WeaviateProtoBase.ConsistencyLevel.CONSISTENCY_LEVEL_ALL;
            }
            if (this.consistencyLevel.equals("QUORUM")) {
                cl = WeaviateProtoBase.ConsistencyLevel.CONSISTENCY_LEVEL_QUORUM;
            }
            batchObjectsRequestBuilder.setConsistencyLevel(cl);
        }
        WeaviateProtoBatch.BatchObjectsRequest batchObjectsRequest = batchObjectsRequestBuilder.build();
        GrpcClient grpcClient = GrpcClient.create(this.config, this.tokenProvider);
        try {
            batchObjectsReply = grpcClient.batchObjects(batchObjectsRequest);
        }
        finally {
            grpcClient.shutdown();
        }
        List<WeaviateErrorMessage> weaviateErrorMessages = batchObjectsReply.getErrorsList().stream().map(WeaviateProtoBatch.BatchObjectsReply.BatchError::getError).filter(e -> !e.isEmpty()).map(msg -> WeaviateErrorMessage.builder().message((String)msg).build()).collect(Collectors.toList());
        if (!weaviateErrorMessages.isEmpty()) {
            WeaviateErrorResponse weaviateErrorResponse = WeaviateErrorResponse.builder().code(422).message(StringUtils.join(weaviateErrorMessages, (String)",")).error(weaviateErrorMessages).build();
            return new Result<Object>(422, null, weaviateErrorResponse);
        }
        ObjectGetResponse[] objectGetResponses = (ObjectGetResponse[])batch.stream().map(o -> {
            ObjectGetResponse resp = new ObjectGetResponse();
            resp.setId(o.getId());
            resp.setClassName(o.getClassName());
            resp.setTenant(o.getTenant());
            ObjectsGetResponseAO2Result result = new ObjectsGetResponseAO2Result();
            result.setStatus("SUCCESS");
            resp.setResult(result);
            return resp;
        }).toArray(ObjectGetResponse[]::new);
        return new Result<ObjectGetResponse[]>(200, objectGetResponses, null);
    }

    private Pair<List<ObjectGetResponse>, List<WeaviateObject>> fetchCreatedAndBuildBatchToReRun(List<WeaviateObject> batch) {
        ArrayList<WeaviateObject> rerunBatch = new ArrayList<WeaviateObject>(batch.size());
        ArrayList<ObjectGetResponse> createdResponses = new ArrayList<ObjectGetResponse>(batch.size());
        for (WeaviateObject batchObject : batch) {
            Result<List<WeaviateObject>> existingResult = this.fetchExistingObject(batchObject);
            if (existingResult.hasErrors() || ObjectUtils.isEmpty(existingResult.getResult())) {
                rerunBatch.add(batchObject);
                continue;
            }
            WeaviateObject existingObject = existingResult.getResult().get(0);
            if (this.isDifferentObject(batchObject, existingObject)) {
                rerunBatch.add(batchObject);
                continue;
            }
            createdResponses.add(this.createResponseFromExistingObject(existingObject));
        }
        return Pair.of(createdResponses, rerunBatch);
    }

    private Result<List<WeaviateObject>> fetchExistingObject(WeaviateObject batchObject) {
        return this.data.objectsGetter().withID(batchObject.getId()).withClassName(batchObject.getClassName()).withVector().run();
    }

    private boolean isDifferentObject(WeaviateObject batchObject, WeaviateObject existingObject) {
        if (!(existingObject.getVector() == null && batchObject.getVector() == null || Arrays.equals((Object[])existingObject.getVector(), (Object[])batchObject.getVector()))) {
            return true;
        }
        Map<String, Object> existingProperties = existingObject.getProperties();
        Map<String, Object> batchProperties = batchObject.getProperties();
        if (existingProperties != null && batchProperties == null || existingProperties == null && batchProperties != null) {
            return true;
        }
        return existingProperties != null && !existingProperties.equals(batchProperties);
    }

    private ObjectGetResponse createResponseFromExistingObject(WeaviateObject existingObject) {
        ObjectsGetResponseAO2Result result = new ObjectsGetResponseAO2Result();
        result.setStatus("SUCCESS");
        ObjectGetResponse response = new ObjectGetResponse();
        response.setId(existingObject.getId());
        response.setClassName(existingObject.getClassName());
        response.setProperties(existingObject.getProperties());
        response.setAdditional(existingObject.getAdditional());
        response.setCreationTimeUnix(existingObject.getCreationTimeUnix());
        response.setLastUpdateTimeUnix(existingObject.getLastUpdateTimeUnix());
        response.setVector(existingObject.getVector());
        response.setVectorWeights(existingObject.getVectorWeights());
        response.setResult(result);
        return response;
    }

    private List<ObjectGetResponse> combineSingleResponses(List<ObjectGetResponse> combinedSingleResponses, List<ObjectGetResponse> createdResponses) {
        if (ObjectUtils.isNotEmpty(createdResponses)) {
            combinedSingleResponses = ObjectUtils.isEmpty(combinedSingleResponses) ? createdResponses : Stream.of(combinedSingleResponses, createdResponses).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return combinedSingleResponses;
    }

    private Result<ObjectGetResponse[]> createFinalResultFromLastResultAndCombinedSingleResponses(Result<ObjectGetResponse[]> lastResult, List<ObjectGetResponse> combinedSingleResponses, List<WeaviateObject> failedBatch) {
        List<WeaviateErrorMessage> messages;
        if (ObjectUtils.isEmpty(failedBatch) && ObjectUtils.isEmpty(combinedSingleResponses)) {
            return lastResult;
        }
        int statusCode = 0;
        Object[] allResponses = null;
        if (ObjectUtils.isNotEmpty((Object)lastResult.getResult())) {
            allResponses = lastResult.getResult();
        }
        if (ObjectUtils.isNotEmpty(combinedSingleResponses)) {
            allResponses = (ObjectGetResponse[])ArrayUtils.addAll((Object[])allResponses, (Object[])combinedSingleResponses.toArray(new ObjectGetResponse[0]));
        }
        if (ObjectUtils.isEmpty(failedBatch)) {
            return new Result<Object[]>(statusCode, allResponses, null);
        }
        String failedIds = failedBatch.stream().map(WeaviateObject::getId).collect(Collectors.joining(", "));
        WeaviateErrorMessage failedIdsMessage = WeaviateErrorMessage.builder().message("Failed ids: " + failedIds).build();
        if (lastResult.hasErrors()) {
            statusCode = lastResult.getError().getStatusCode();
            List<WeaviateErrorMessage> prevMessages = lastResult.getError().getMessages();
            messages = new ArrayList<WeaviateErrorMessage>(prevMessages.size() + 1);
            messages.addAll(prevMessages);
            messages.add(failedIdsMessage);
        } else {
            messages = Collections.singletonList(failedIdsMessage);
        }
        return new Result<Object[]>(statusCode, allResponses, WeaviateErrorResponse.builder().error(messages).code(statusCode).build());
    }

    private /* synthetic */ void lambda$runInThread$5(CompletableFuture undoneFuture, Result result, Throwable ex) {
        this.undoneFutures.remove(undoneFuture);
    }

    public static class AutoBatchConfig {
        public static final int BATCH_SIZE = 100;
        public static final int POOL_SIZE = 1;
        public static final int AWAIT_TERMINATION_MS = 10000;
        private final int batchSize;
        private final int poolSize;
        private final int awaitTerminationMs;
        private final Consumer<Result<ObjectGetResponse[]>> callback;

        private AutoBatchConfig(int batchSize, int poolSize, int awaitTerminationMs, Consumer<Result<ObjectGetResponse[]>> callback) {
            Assert.requireGreaterEqual(batchSize, 1, "batchSize");
            Assert.requireGreaterEqual(poolSize, 1, "corePoolSize");
            Assert.requireGreater(awaitTerminationMs, 0, "awaitTerminationMs");
            this.batchSize = batchSize;
            this.poolSize = poolSize;
            this.awaitTerminationMs = awaitTerminationMs;
            this.callback = callback;
        }

        public static AutoBatchConfigBuilder defaultConfig() {
            return AutoBatchConfig.builder().batchSize(100).poolSize(1).awaitTerminationMs(10000).callback(null);
        }

        public static AutoBatchConfigBuilder builder() {
            return new AutoBatchConfigBuilder();
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public int getPoolSize() {
            return this.poolSize;
        }

        public int getAwaitTerminationMs() {
            return this.awaitTerminationMs;
        }

        public Consumer<Result<ObjectGetResponse[]>> getCallback() {
            return this.callback;
        }

        public String toString() {
            return "ObjectsBatcher.AutoBatchConfig(batchSize=" + this.getBatchSize() + ", poolSize=" + this.getPoolSize() + ", awaitTerminationMs=" + this.getAwaitTerminationMs() + ", callback=" + this.getCallback() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutoBatchConfig)) {
                return false;
            }
            AutoBatchConfig other = (AutoBatchConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBatchSize() != other.getBatchSize()) {
                return false;
            }
            if (this.getPoolSize() != other.getPoolSize()) {
                return false;
            }
            if (this.getAwaitTerminationMs() != other.getAwaitTerminationMs()) {
                return false;
            }
            Consumer<Result<ObjectGetResponse[]>> this$callback = this.getCallback();
            Consumer<Result<ObjectGetResponse[]>> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AutoBatchConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBatchSize();
            result = result * 59 + this.getPoolSize();
            result = result * 59 + this.getAwaitTerminationMs();
            Consumer<Result<ObjectGetResponse[]>> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        public static class AutoBatchConfigBuilder {
            private int batchSize;
            private int poolSize;
            private int awaitTerminationMs;
            private Consumer<Result<ObjectGetResponse[]>> callback;

            AutoBatchConfigBuilder() {
            }

            public AutoBatchConfigBuilder batchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public AutoBatchConfigBuilder poolSize(int poolSize) {
                this.poolSize = poolSize;
                return this;
            }

            public AutoBatchConfigBuilder awaitTerminationMs(int awaitTerminationMs) {
                this.awaitTerminationMs = awaitTerminationMs;
                return this;
            }

            public AutoBatchConfigBuilder callback(Consumer<Result<ObjectGetResponse[]>> callback) {
                this.callback = callback;
                return this;
            }

            public AutoBatchConfig build() {
                return new AutoBatchConfig(this.batchSize, this.poolSize, this.awaitTerminationMs, this.callback);
            }

            public String toString() {
                return "ObjectsBatcher.AutoBatchConfig.AutoBatchConfigBuilder(batchSize=" + this.batchSize + ", poolSize=" + this.poolSize + ", awaitTerminationMs=" + this.awaitTerminationMs + ", callback=" + this.callback + ")";
            }
        }
    }

    public static class BatchRetriesConfig {
        public static final int MAX_TIMEOUT_RETRIES = 3;
        public static final int MAX_CONNECTION_RETRIES = 3;
        public static final int RETRIES_INTERVAL = 2000;
        private final int maxTimeoutRetries;
        private final int maxConnectionRetries;
        private final int retriesIntervalMs;

        private BatchRetriesConfig(int maxTimeoutRetries, int maxConnectionRetries, int retriesIntervalMs) {
            Assert.requireGreaterEqual(maxTimeoutRetries, 0, "maxTimeoutRetries");
            Assert.requireGreaterEqual(maxConnectionRetries, 0, "maxConnectionRetries");
            Assert.requireGreater(retriesIntervalMs, 0, "retriesIntervalMs");
            this.maxTimeoutRetries = maxTimeoutRetries;
            this.maxConnectionRetries = maxConnectionRetries;
            this.retriesIntervalMs = retriesIntervalMs;
        }

        public static BatchRetriesConfigBuilder defaultConfig() {
            return BatchRetriesConfig.builder().maxTimeoutRetries(3).maxConnectionRetries(3).retriesIntervalMs(2000);
        }

        public static BatchRetriesConfigBuilder builder() {
            return new BatchRetriesConfigBuilder();
        }

        public int getMaxTimeoutRetries() {
            return this.maxTimeoutRetries;
        }

        public int getMaxConnectionRetries() {
            return this.maxConnectionRetries;
        }

        public int getRetriesIntervalMs() {
            return this.retriesIntervalMs;
        }

        public String toString() {
            return "ObjectsBatcher.BatchRetriesConfig(maxTimeoutRetries=" + this.getMaxTimeoutRetries() + ", maxConnectionRetries=" + this.getMaxConnectionRetries() + ", retriesIntervalMs=" + this.getRetriesIntervalMs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchRetriesConfig)) {
                return false;
            }
            BatchRetriesConfig other = (BatchRetriesConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxTimeoutRetries() != other.getMaxTimeoutRetries()) {
                return false;
            }
            if (this.getMaxConnectionRetries() != other.getMaxConnectionRetries()) {
                return false;
            }
            return this.getRetriesIntervalMs() == other.getRetriesIntervalMs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchRetriesConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTimeoutRetries();
            result = result * 59 + this.getMaxConnectionRetries();
            result = result * 59 + this.getRetriesIntervalMs();
            return result;
        }

        public static class BatchRetriesConfigBuilder {
            private int maxTimeoutRetries;
            private int maxConnectionRetries;
            private int retriesIntervalMs;

            BatchRetriesConfigBuilder() {
            }

            public BatchRetriesConfigBuilder maxTimeoutRetries(int maxTimeoutRetries) {
                this.maxTimeoutRetries = maxTimeoutRetries;
                return this;
            }

            public BatchRetriesConfigBuilder maxConnectionRetries(int maxConnectionRetries) {
                this.maxConnectionRetries = maxConnectionRetries;
                return this;
            }

            public BatchRetriesConfigBuilder retriesIntervalMs(int retriesIntervalMs) {
                this.retriesIntervalMs = retriesIntervalMs;
                return this;
            }

            public BatchRetriesConfig build() {
                return new BatchRetriesConfig(this.maxTimeoutRetries, this.maxConnectionRetries, this.retriesIntervalMs);
            }

            public String toString() {
                return "ObjectsBatcher.BatchRetriesConfig.BatchRetriesConfigBuilder(maxTimeoutRetries=" + this.maxTimeoutRetries + ", maxConnectionRetries=" + this.maxConnectionRetries + ", retriesIntervalMs=" + this.retriesIntervalMs + ")";
            }
        }
    }

    private static class SleepDelayedExecutor
    implements DelayedExecutor<Result<ObjectGetResponse[]>> {
        private SleepDelayedExecutor() {
        }

        @Override
        public Result<ObjectGetResponse[]> delayed(int delay, Supplier<Result<ObjectGetResponse[]>> supplier) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return supplier.get();
        }

        @Override
        public Result<ObjectGetResponse[]> now(Result<ObjectGetResponse[]> result) {
            return result;
        }
    }

    private static class ExecutorServiceDelayedExecutor
    implements DelayedExecutor<CompletableFuture<Result<ObjectGetResponse[]>>> {
        private final ScheduledExecutorService executorService;

        @Override
        public CompletableFuture<Result<ObjectGetResponse[]>> delayed(int delay, Supplier<CompletableFuture<Result<ObjectGetResponse[]>>> supplier) {
            Executor executor = runnable -> this.executorService.schedule(runnable, (long)delay, TimeUnit.MILLISECONDS);
            return CompletableFuture.supplyAsync(supplier, executor).thenCompose(f -> f);
        }

        @Override
        public CompletableFuture<Result<ObjectGetResponse[]>> now(Result<ObjectGetResponse[]> result) {
            return CompletableFuture.completedFuture(result);
        }

        public ExecutorServiceDelayedExecutor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
        }
    }

    private static interface DelayedExecutor<T> {
        public T delayed(int var1, Supplier<T> var2);

        public T now(Result<ObjectGetResponse[]> var1);
    }
}

