/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class NearObjectArgument
implements Argument {
    private final String id;
    private final String beacon;
    private final Float certainty;
    private final Float distance;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            arg.add(String.format("id:%s", Serializer.quote(this.id)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.beacon)) {
            arg.add(String.format("beacon:%s", Serializer.quote(this.beacon)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance:%s", this.distance));
        }
        return String.format("nearObject:{%s}", String.join((CharSequence)" ", arg));
    }

    NearObjectArgument(String id, String beacon, Float certainty, Float distance) {
        this.id = id;
        this.beacon = beacon;
        this.certainty = certainty;
        this.distance = distance;
    }

    public static NearObjectArgumentBuilder builder() {
        return new NearObjectArgumentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getBeacon() {
        return this.beacon;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String toString() {
        return "NearObjectArgument(id=" + this.getId() + ", beacon=" + this.getBeacon() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearObjectArgument)) {
            return false;
        }
        NearObjectArgument other = (NearObjectArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$beacon = this.getBeacon();
        String other$beacon = other.getBeacon();
        return !(this$beacon == null ? other$beacon != null : !this$beacon.equals(other$beacon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearObjectArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $beacon = this.getBeacon();
        result = result * 59 + ($beacon == null ? 43 : $beacon.hashCode());
        return result;
    }

    public static class NearObjectArgumentBuilder {
        private String id;
        private String beacon;
        private Float certainty;
        private Float distance;

        NearObjectArgumentBuilder() {
        }

        public NearObjectArgumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NearObjectArgumentBuilder beacon(String beacon) {
            this.beacon = beacon;
            return this;
        }

        public NearObjectArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearObjectArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearObjectArgument build() {
            return new NearObjectArgument(this.id, this.beacon, this.certainty, this.distance);
        }

        public String toString() {
            return "NearObjectArgument.NearObjectArgumentBuilder(id=" + this.id + ", beacon=" + this.beacon + ", certainty=" + this.certainty + ", distance=" + this.distance + ")";
        }
    }
}

