/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.misc.model;

public class PQConfig {
    private final Boolean enabled;
    private final Boolean bitCompression;
    private final Integer segments;
    private final Integer centroids;
    private final Encoder encoder;

    PQConfig(Boolean enabled, Boolean bitCompression, Integer segments, Integer centroids, Encoder encoder) {
        this.enabled = enabled;
        this.bitCompression = bitCompression;
        this.segments = segments;
        this.centroids = centroids;
        this.encoder = encoder;
    }

    public static PQConfigBuilder builder() {
        return new PQConfigBuilder();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getBitCompression() {
        return this.bitCompression;
    }

    public Integer getSegments() {
        return this.segments;
    }

    public Integer getCentroids() {
        return this.centroids;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public String toString() {
        return "PQConfig(enabled=" + this.getEnabled() + ", bitCompression=" + this.getBitCompression() + ", segments=" + this.getSegments() + ", centroids=" + this.getCentroids() + ", encoder=" + this.getEncoder() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PQConfig)) {
            return false;
        }
        PQConfig other = (PQConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$bitCompression = this.getBitCompression();
        Boolean other$bitCompression = other.getBitCompression();
        if (this$bitCompression == null ? other$bitCompression != null : !((Object)this$bitCompression).equals(other$bitCompression)) {
            return false;
        }
        Integer this$segments = this.getSegments();
        Integer other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        Integer this$centroids = this.getCentroids();
        Integer other$centroids = other.getCentroids();
        if (this$centroids == null ? other$centroids != null : !((Object)this$centroids).equals(other$centroids)) {
            return false;
        }
        Encoder this$encoder = this.getEncoder();
        Encoder other$encoder = other.getEncoder();
        return !(this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PQConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $bitCompression = this.getBitCompression();
        result = result * 59 + ($bitCompression == null ? 43 : ((Object)$bitCompression).hashCode());
        Integer $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        Integer $centroids = this.getCentroids();
        result = result * 59 + ($centroids == null ? 43 : ((Object)$centroids).hashCode());
        Encoder $encoder = this.getEncoder();
        result = result * 59 + ($encoder == null ? 43 : $encoder.hashCode());
        return result;
    }

    public static class PQConfigBuilder {
        private Boolean enabled;
        private Boolean bitCompression;
        private Integer segments;
        private Integer centroids;
        private Encoder encoder;

        PQConfigBuilder() {
        }

        public PQConfigBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PQConfigBuilder bitCompression(Boolean bitCompression) {
            this.bitCompression = bitCompression;
            return this;
        }

        public PQConfigBuilder segments(Integer segments) {
            this.segments = segments;
            return this;
        }

        public PQConfigBuilder centroids(Integer centroids) {
            this.centroids = centroids;
            return this;
        }

        public PQConfigBuilder encoder(Encoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public PQConfig build() {
            return new PQConfig(this.enabled, this.bitCompression, this.segments, this.centroids, this.encoder);
        }

        public String toString() {
            return "PQConfig.PQConfigBuilder(enabled=" + this.enabled + ", bitCompression=" + this.bitCompression + ", segments=" + this.segments + ", centroids=" + this.centroids + ", encoder=" + this.encoder + ")";
        }
    }

    public static class Encoder {
        private final String type;
        private final String distribution;

        Encoder(String type, String distribution) {
            this.type = type;
            this.distribution = distribution;
        }

        public static EncoderBuilder builder() {
            return new EncoderBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getDistribution() {
            return this.distribution;
        }

        public String toString() {
            return "PQConfig.Encoder(type=" + this.getType() + ", distribution=" + this.getDistribution() + ")";
        }

        public static class EncoderBuilder {
            private String type;
            private String distribution;

            EncoderBuilder() {
            }

            public EncoderBuilder type(String type) {
                this.type = type;
                return this;
            }

            public EncoderBuilder distribution(String distribution) {
                this.distribution = distribution;
                return this;
            }

            public Encoder build() {
                return new Encoder(this.type, this.distribution);
            }

            public String toString() {
                return "PQConfig.Encoder.EncoderBuilder(type=" + this.type + ", distribution=" + this.distribution + ")";
            }
        }
    }
}

