/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.dropwizard.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.zackehh.dotnotes.DotNotes;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.jackson.Jackson;
import io.whitfin.dottie.joiner.NotationJoiner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public class EnvironmentSubstitutor
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider delegate;
    private final ObjectMapper mapper;
    private final String namespace;

    public EnvironmentSubstitutor(String namespace, ConfigurationSourceProvider delegate) {
        this(namespace, delegate, Jackson.newObjectMapper((JsonFactory)new YAMLFactory()));
    }

    public EnvironmentSubstitutor(String namespace, ConfigurationSourceProvider delegate, ObjectMapper mapper) {
        this.namespace = Objects.requireNonNull(namespace).toUpperCase();
        this.delegate = Objects.requireNonNull(delegate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public InputStream open(String path) throws IOException {
        try (InputStream in = this.delegate.open(path);){
            ObjectNode config = (ObjectNode)this.mapper.readValue(in, ObjectNode.class);
            NotationJoiner joiner = new NotationJoiner();
            for (Map.Entry<String, String> prop : System.getenv().entrySet()) {
                JsonNode parsedValue;
                String key = prop.getKey();
                String value = prop.getValue();
                if (!key.startsWith(this.namespace + "_")) continue;
                for (String segment : key.substring(this.namespace.length() + 1).split("_")) {
                    JsonNode parsed;
                    segment = segment.toLowerCase();
                    try {
                        parsed = this.mapper.readTree(segment);
                    }
                    catch (IOException e) {
                        parsed = TextNode.valueOf((String)segment);
                    }
                    if (parsed.isTextual()) {
                        joiner.append(new String[]{parsed.asText()});
                    }
                    if (!parsed.isNumber()) continue;
                    joiner.append(new Integer[]{parsed.asInt()});
                }
                try {
                    parsedValue = this.mapper.readTree(value);
                }
                catch (IOException e) {
                    parsedValue = TextNode.valueOf((String)value);
                }
                try {
                    DotNotes.create((JsonNode)config, (String)joiner.toString(), (JsonNode)parsedValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                joiner.reset();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mapper.writeValueAsBytes((Object)config));
            return byteArrayInputStream;
        }
    }
}

