package io.winterframework.mod.http.base;

import io.winterframework.core.v1.Module;
import io.winterframework.mod.base.converter.ObjectConverter;
import io.winterframework.mod.http.base.header.HeaderCodec;
import io.winterframework.mod.http.base.internal.ParameterConverter;
import io.winterframework.mod.http.base.internal.header.AcceptCodec;
import io.winterframework.mod.http.base.internal.header.AcceptLanguageCodec;
import io.winterframework.mod.http.base.internal.header.ContentDispositionCodec;
import io.winterframework.mod.http.base.internal.header.ContentTypeCodec;
import io.winterframework.mod.http.base.internal.header.CookieCodec;
import io.winterframework.mod.http.base.internal.header.GenericHeaderService;
import io.winterframework.mod.http.base.internal.header.SetCookieCodec;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value= {"io.winterframework.core.compiler.WinterCompiler", "1"}, date = "2021-05-17T15:05:07.596628430+02:00[Europe/Paris]")
public final class Base extends Module {

	private Bean<ContentDispositionCodec> contentDispositionCodec;
	private Bean<ContentTypeCodec> contentTypeCodec;
	private Bean<AcceptLanguageCodec> acceptLanguageCodec;
	private Bean<GenericHeaderService> headerService;
	private Bean<ObjectConverter<String>> parameterConverter;
	private Bean<SetCookieCodec> setCookieCodec;
	private Bean<AcceptCodec> acceptCodec;
	private Bean<CookieCodec> cookieCodec;

	private Base(@Socket(name = "headerCodecs", wiredTo = {"parameterConverter", "headerService", "acceptLanguageCodec", "contentTypeCodec", "cookieCodec", "contentDispositionCodec", "acceptCodec", "setCookieCodec"}) Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs, @Socket(name = "parameterConverter", wiredTo = {"headerService", "acceptLanguageCodec", "contentTypeCodec", "cookieCodec", "contentDispositionCodec", "acceptCodec", "setCookieCodec"}) Optional<Supplier<ObjectConverter<String>>> parameterConverterOverride) {
		super("io.winterframework.mod.http.base");

		this.contentDispositionCodec = this.with(ModuleBeanBuilder
			.singleton("contentDispositionCodec", () -> {
				ContentDispositionCodec contentDispositionCodec = new ContentDispositionCodec();

				return contentDispositionCodec;
			})
		);
		this.contentTypeCodec = this.with(ModuleBeanBuilder
			.singleton("contentTypeCodec", () -> {
				ContentTypeCodec contentTypeCodec = new ContentTypeCodec();

				return contentTypeCodec;
			})
		);
		this.acceptLanguageCodec = this.with(ModuleBeanBuilder
			.singleton("acceptLanguageCodec", () -> {
				AcceptLanguageCodec acceptLanguageCodec = new AcceptLanguageCodec();

				return acceptLanguageCodec;
			})
		);
		this.headerService = this.with(ModuleBeanBuilder
			.singleton("headerService", () -> {
				GenericHeaderService headerService = new GenericHeaderService();
				headerService.setHeaderCodecs(new BeanAggregator<HeaderCodec<?>>()
					.add(this.contentDispositionCodec.get())
					.add(this.contentTypeCodec.get())
					.add(this.acceptLanguageCodec.get())
					.add(this.setCookieCodec.get())
					.add(this.acceptCodec.get())
					.add(this.cookieCodec.get())
					.add(headerCodecs.orElse(() -> null).get())
				.toList());
				return headerService;
			})
		);
		this.parameterConverter = this.with(WrapperBeanBuilder
			.singleton("parameterConverter", () -> {
				ParameterConverter parameterConverter = new ParameterConverter();

				return parameterConverter;
			})
			.override(parameterConverterOverride)
		);
		this.setCookieCodec = this.with(ModuleBeanBuilder
			.singleton("setCookieCodec", () -> {
				SetCookieCodec setCookieCodec = new SetCookieCodec();

				return setCookieCodec;
			})
		);
		this.acceptCodec = this.with(ModuleBeanBuilder
			.singleton("acceptCodec", () -> {
				AcceptCodec acceptCodec = new AcceptCodec();

				return acceptCodec;
			})
		);
		this.cookieCodec = this.with(ModuleBeanBuilder
			.singleton("cookieCodec", () -> {
				CookieCodec cookieCodec = new CookieCodec(
					this.parameterConverter.get()
				);

				return cookieCodec;
			})
		);
	}

	private ContentDispositionCodec contentDispositionCodec() {
		return this.contentDispositionCodec.get();
	}

	private ContentTypeCodec contentTypeCodec() {
		return this.contentTypeCodec.get();
	}

	private AcceptLanguageCodec acceptLanguageCodec() {
		return this.acceptLanguageCodec.get();
	}

	public GenericHeaderService headerService() {
		return this.headerService.get();
	}

	private ObjectConverter<String> parameterConverter() {
		return this.parameterConverter.get();
	}

	private SetCookieCodec setCookieCodec() {
		return this.setCookieCodec.get();
	}

	private AcceptCodec acceptCodec() {
		return this.acceptCodec.get();
	}

	private CookieCodec cookieCodec() {
		return this.cookieCodec.get();
	}

	public static final class Builder extends ModuleBuilder<Base> {

		private Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs = Optional.empty();
		private Optional<Supplier<ObjectConverter<String>>> parameterConverter = Optional.empty();

		protected Base doBuild() {
			return new Base(this.headerCodecs, this.parameterConverter);
		}

		public Builder setHeaderCodecs(List<HeaderCodec<?>> headerCodecs) {
			this.headerCodecs = Optional.ofNullable(headerCodecs != null ? () -> headerCodecs : null);
			return this;
		}

		public Builder setParameterConverter(ObjectConverter<String> parameterConverter) {
			this.parameterConverter = Optional.ofNullable(parameterConverter != null ? () -> parameterConverter : null);
			return this;
		}
	}

	public static final class Linker extends ModuleLinker<Base> {

		public Linker(Map<String, Object> sockets) {
			super(sockets);
		}

		@SuppressWarnings("unchecked")
		protected Base link() {
			return new Base(
				(Optional<Supplier<List<HeaderCodec<?>>>>)this.sockets.get("headerCodecs"),
				(Optional<Supplier<ObjectConverter<String>>>)this.sockets.get("parameterConverter")
			);
		}
	}
}
