package optimajet.workflow.ignite;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

@Getter
@Setter
@EqualsAndHashCode
public class WorkflowProcessInstance implements Serializable {
    private String activityName;
    private UUID id;
    private boolean determiningParametersChanged;
    private String previousActivity;
    private String previousActivityForDirect;
    private String previousActivityForReverse;
    private String previousState;
    private String previousStateForDirect;
    private String previousStateForReverse;
    private UUID schemeId;
    private String stateName;
    private UUID parentProcessId;
    private UUID rootProcessId;
    private List<WorkflowProcessInstancePersistence> persistence;
}