package optimajet.workflow.ignite;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

import java.io.Serializable;
import java.util.UUID;

@Getter
@Setter
@EqualsAndHashCode
public class WorkflowProcessScheme implements Serializable {
    private String definingParameters;
    @QuerySqlField(index = true)
    private String definingParametersHash;
    private UUID id;
    @QuerySqlField(index = true)
    private boolean obsolete;
    @QuerySqlField(index = true)
    private String schemeCode;
    private String scheme;
    @QuerySqlField(index = true)
    private UUID rootSchemeId;
    @QuerySqlField(index = true)
    private String rootSchemeCode;
    private String allowedActivities;
    private String startingTransition;
}
