package optimajet.workflow.ignite;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import optimajet.workflow.core.util.DateUtil;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter
@EqualsAndHashCode
public class WorkflowProcessTimer implements Serializable {
    private UUID id;
    @QuerySqlField(index = true)
    private UUID processId;
    @QuerySqlField(index = true)
    private String name;
    @QuerySqlField(index = true)
    private Date nextExecutionDateTime;
    @QuerySqlField(index = true)
    private boolean ignore;

    Date getNextExecutionDateTime() {
        return DateUtil.copy(nextExecutionDateTime);
    }

    void setNextExecutionDateTime(Date nextExecutionDateTime) {
        this.nextExecutionDateTime = DateUtil.copy(nextExecutionDateTime);
    }
}
