package optimajet.workflow.ignite;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import optimajet.workflow.core.util.DateUtil;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter
@EqualsAndHashCode
public class WorkflowProcessTransitionHistory implements Serializable {
    private String actorIdentityId;
    private String executorIdentityId;
    private String fromActivityName;
    private String fromStateName;
    private UUID id;
    private boolean finalised;
    @QuerySqlField(index = true)
    private UUID processId;
    private String toActivityName;
    private String toStateName;
    private String transitionClassifier;
    private Date transitionTime;
    private String triggerName;

    Date getTransitionTime() {
        return DateUtil.copy(transitionTime);
    }

    void setTransitionTime(Date transitionTime) {
        this.transitionTime = DateUtil.copy(transitionTime);
    }
}
