/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method;

import io.wttech.markuply.engine.component.ComponentDefinitionException;
import io.wttech.markuply.engine.component.method.LambdaSpreaderFactory;
import io.wttech.markuply.engine.component.method.MethodComponent;
import io.wttech.markuply.engine.component.method.ReflectiveMethodComponent;
import io.wttech.markuply.engine.component.method.function.TriFunction;
import io.wttech.markuply.engine.component.method.function.UnifiedSupplier;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolver;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolverFactory;
import io.wttech.markuply.engine.component.method.spreader.BiFunctionParameterSpreader;
import io.wttech.markuply.engine.component.method.spreader.FunctionParameterSpreader;
import io.wttech.markuply.engine.component.method.spreader.ParameterSpreader;
import io.wttech.markuply.engine.component.method.spreader.SupplierParameterSpreader;
import io.wttech.markuply.engine.component.method.spreader.TriFunctionParameterSpreader;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class LambdaComponentFactory {
    private static final Map<Integer, LambdaSpreaderFactory<?>> SPREADER_FACTORIES = new HashMap();
    private final List<MethodArgumentResolverFactory> resolverFactories;

    public MethodComponent build(Object instance, Method method) {
        if (method.getParameterCount() > 3) {
            throw new ComponentDefinitionException("Method to augment cannot contain more than three arguments");
        }
        LambdaSpreaderFactory<?> lambdaSpreaderFactory = SPREADER_FACTORIES.get(method.getParameterCount());
        ParameterSpreader<Mono<String>> parameterSpreader = lambdaSpreaderFactory.buildRenderSpreader(instance, method);
        List<MethodArgumentResolver> resolvers = this.buildResolvers(method);
        return MethodComponent.of(parameterSpreader, resolvers);
    }

    public ReflectiveMethodComponent buildReflective(Object instance, Method method) {
        if (method.getParameterCount() > 3) {
            throw new ComponentDefinitionException("Method to augment cannot contain more than three arguments");
        }
        List<MethodArgumentResolver> resolvers = this.buildResolvers(method);
        return ReflectiveMethodComponent.of(instance, method, resolvers);
    }

    private List<MethodArgumentResolver> buildResolvers(Method method) {
        Parameter[] parameters;
        ArrayList<MethodArgumentResolver> resolvers = new ArrayList<MethodArgumentResolver>();
        for (Parameter currentParameter : parameters = method.getParameters()) {
            MethodArgumentResolver resolver = this.resolverFactories.stream().map(factory -> factory.createResolver(currentParameter)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new ComponentDefinitionException("Parameter resolver does not exist. Method: " + method.getDeclaringClass().getName() + "." + method.getName() + ". Parameter: " + currentParameter.getName()));
            resolvers.add(resolver);
        }
        return resolvers;
    }

    public LambdaComponentFactory(List<MethodArgumentResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    static {
        SPREADER_FACTORIES.put(0, LambdaSpreaderFactory.of(UnifiedSupplier.class, SupplierParameterSpreader::of));
        SPREADER_FACTORIES.put(1, LambdaSpreaderFactory.of(Function.class, FunctionParameterSpreader::of));
        SPREADER_FACTORIES.put(2, LambdaSpreaderFactory.of(BiFunction.class, BiFunctionParameterSpreader::of));
        SPREADER_FACTORIES.put(3, LambdaSpreaderFactory.of(TriFunction.class, TriFunctionParameterSpreader::of));
    }
}

