/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method;

import io.wttech.markuply.engine.component.method.spreader.ParameterSpreader;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

public class LambdaSpreaderFactory<T> {
    private static final Class<?> ERASED_TYPE = Object.class;
    private final Class<T> functionType;
    private final Function<T, ParameterSpreader> spreaderCreator;

    public ParameterSpreader<Mono<String>> buildRenderSpreader(Object instance, Method method) {
        if (!method.getReturnType().equals(Mono.class)) {
            throw new IllegalArgumentException("Method to augment must return Mono<String>");
        }
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            List<Class<?>> erasedParameterTypeList = Stream.generate(() -> Object.class).limit(parameterTypes.length).collect(Collectors.toList());
            ArrayList realParameterTypeList = new ArrayList();
            Collections.addAll(realParameterTypeList, parameterTypes);
            Class<?> returnType = method.getReturnType();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = lookup.unreflect(method);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(this.functionType, method.getDeclaringClass()), MethodType.methodType(ERASED_TYPE, erasedParameterTypeList), methodHandle, MethodType.methodType(returnType, realParameterTypeList));
            Object untypedLambda = callSite.getTarget().bindTo(instance).invoke();
            return this.spreaderCreator.apply(untypedLambda);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private LambdaSpreaderFactory(Class<T> functionType, Function<T, ParameterSpreader> spreaderCreator) {
        this.functionType = functionType;
        this.spreaderCreator = spreaderCreator;
    }

    public static <T> LambdaSpreaderFactory<T> of(Class<T> functionType, Function<T, ParameterSpreader> spreaderCreator) {
        return new LambdaSpreaderFactory<T>(functionType, spreaderCreator);
    }
}

