/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method;

import io.wttech.markuply.engine.component.MarkuplyComponent;
import io.wttech.markuply.engine.component.MarkuplyComponentContext;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolver;
import io.wttech.markuply.engine.component.method.spreader.ParameterSpreader;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class MethodComponent
implements MarkuplyComponent {
    private final ParameterSpreader<Mono<String>> spreader;
    private final List<MethodArgumentResolver> resolvers;

    @Override
    public Mono<String> render(MarkuplyComponentContext context) {
        try {
            List<Object> parameters = this.resolvers.stream().map(resolver -> resolver.resolve(context)).collect(Collectors.toList());
            return this.spreader.invoke(parameters);
        }
        catch (Throwable throwable) {
            return Mono.error((Throwable)throwable);
        }
    }

    private MethodComponent(ParameterSpreader<Mono<String>> spreader, List<MethodArgumentResolver> resolvers) {
        this.spreader = spreader;
        this.resolvers = resolvers;
    }

    public static MethodComponent of(ParameterSpreader<Mono<String>> spreader, List<MethodArgumentResolver> resolvers) {
        return new MethodComponent(spreader, resolvers);
    }
}

