/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method;

import io.wttech.markuply.engine.component.MarkuplyComponent;
import io.wttech.markuply.engine.component.MarkuplyComponentContext;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolver;
import java.lang.reflect.Method;
import java.util.List;
import reactor.core.publisher.Mono;

public class ReflectiveMethodComponent
implements MarkuplyComponent {
    private final Object targetInstance;
    private final Method method;
    private final List<MethodArgumentResolver> resolvers;

    @Override
    public Mono<String> render(MarkuplyComponentContext context) {
        try {
            Object[] parameters = this.resolvers.stream().map(resolver -> resolver.resolve(context)).toArray();
            Object result = this.method.invoke(this.targetInstance, parameters);
            return (Mono)result;
        }
        catch (Throwable throwable) {
            return Mono.error((Throwable)throwable);
        }
    }

    private ReflectiveMethodComponent(Object targetInstance, Method method, List<MethodArgumentResolver> resolvers) {
        this.targetInstance = targetInstance;
        this.method = method;
        this.resolvers = resolvers;
    }

    public static ReflectiveMethodComponent of(Object targetInstance, Method method, List<MethodArgumentResolver> resolvers) {
        return new ReflectiveMethodComponent(targetInstance, method, resolvers);
    }
}

