/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method.resolver.context;

import io.wttech.markuply.engine.component.MarkuplyComponentContext;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolver;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolverFactory;
import io.wttech.markuply.engine.component.method.resolver.context.Context;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class TypedPageContextResolverFactory
implements MethodArgumentResolverFactory {
    @Override
    public Optional<MethodArgumentResolver> createResolver(Parameter parameter) {
        if (parameter.isAnnotationPresent(Context.class)) {
            return Optional.of(TypedPageContextResolver.of(parameter.getType()));
        }
        return Optional.empty();
    }

    private static class TypedPageContextResolver
    implements MethodArgumentResolver {
        private final Class<?> contextKey;

        @Override
        public Object resolve(MarkuplyComponentContext context) {
            return context.getPageContext().get(this.contextKey);
        }

        private TypedPageContextResolver(Class<?> contextKey) {
            this.contextKey = contextKey;
        }

        public static TypedPageContextResolver of(Class<?> contextKey) {
            return new TypedPageContextResolver(contextKey);
        }
    }
}

