/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method.resolver.properties;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wttech.markuply.engine.component.MarkuplyComponentContext;
import io.wttech.markuply.engine.component.method.resolver.ArgumentResolutionException;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolver;
import io.wttech.markuply.engine.component.method.resolver.MethodArgumentResolverFactory;
import io.wttech.markuply.engine.component.method.resolver.properties.Props;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class TypedPropsResolverFactory
implements MethodArgumentResolverFactory {
    private final ObjectMapper objectMapper;

    @Override
    public Optional<MethodArgumentResolver> createResolver(Parameter parameter) {
        if (parameter.isAnnotationPresent(Props.class) && !parameter.getType().equals(String.class)) {
            return Optional.of(new TypedPropsResolver(this.objectMapper, parameter.getType()));
        }
        return Optional.empty();
    }

    public TypedPropsResolverFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static class TypedPropsResolver
    implements MethodArgumentResolver {
        private final ObjectMapper objectMapper;
        private final Class<?> targetType;

        @Override
        public Object resolve(MarkuplyComponentContext context) {
            try {
                String stringProps = context.getProps();
                return this.objectMapper.readValue(stringProps, this.targetType);
            }
            catch (JsonProcessingException e) {
                throw new ArgumentResolutionException("Cannot parse data-props as " + this.targetType.getName(), e);
            }
        }

        public TypedPropsResolver(ObjectMapper objectMapper, Class<?> targetType) {
            this.objectMapper = objectMapper;
            this.targetType = targetType;
        }
    }
}

