/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.component.method.resolver.section;

import io.wttech.markuply.engine.MarkuplyException;
import io.wttech.markuply.engine.component.method.resolver.section.ChildrenRenderer;
import io.wttech.markuply.engine.pipeline.context.PageContext;
import io.wttech.markuply.engine.template.graph.NamedRenderFunctions;
import reactor.core.publisher.Mono;

public class SectionRenderer
implements ChildrenRenderer {
    private final NamedRenderFunctions sections;
    private final PageContext originalContext;

    @Override
    public Mono<String> render() {
        return this.render(this.originalContext);
    }

    @Override
    public Mono<String> render(String name) {
        return this.render(name, this.originalContext);
    }

    @Override
    public Mono<String> render(PageContext context) {
        return this.sections.findDefaultSection().orElseThrow(() -> new MarkuplyException("There is no default section to render. All are named.")).render(context);
    }

    @Override
    public Mono<String> render(String name, PageContext context) {
        return this.sections.findSection(name).orElseThrow(() -> new MarkuplyException("There is no section named " + name + " to render.")).render(context);
    }

    private SectionRenderer(NamedRenderFunctions sections, PageContext originalContext) {
        this.sections = sections;
        this.originalContext = originalContext;
    }

    public static SectionRenderer of(NamedRenderFunctions sections, PageContext originalContext) {
        return new SectionRenderer(sections, originalContext);
    }
}

