/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.configuration;

import io.wttech.markuply.engine.configuration.ConditionalOnConfigurationProperties;
import io.wttech.markuply.engine.configuration.OptionalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnConfigurationPropertiesCondition
extends SpringBootCondition {
    private static final Logger log = LoggerFactory.getLogger(OnConfigurationPropertiesCondition.class);

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotation mergedAnnotation = metadata.getAnnotations().get(ConditionalOnConfigurationProperties.class);
        String prefix = mergedAnnotation.getString("prefix");
        Class targetClass = mergedAnnotation.getClass("targetClass");
        if (!OptionalProperties.class.isAssignableFrom(targetClass)) {
            return ConditionOutcome.noMatch((String)"Target type does not implement the OptionalProperties interface.");
        }
        Object bean = Binder.get((Environment)context.getEnvironment()).bind(prefix, targetClass).orElse(null);
        if (bean == null) {
            return ConditionOutcome.noMatch((String)"Binding properties to target type resulted in null value.");
        }
        OptionalProperties props = (OptionalProperties)bean;
        if (props.isPresent()) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch((String)"Properties are not present.");
    }
}

