/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.classpath;

import io.wttech.markuply.engine.pipeline.classpath.ClasspathPageRepository;
import io.wttech.markuply.engine.pipeline.classpath.ClasspathPipeline;
import io.wttech.markuply.engine.pipeline.context.PageContext;
import io.wttech.markuply.engine.renderer.RenderFunctionProvider;
import lombok.NonNull;
import reactor.core.publisher.Mono;

public class ClasspathPageProcessor
implements ClasspathPipeline {
    @NonNull
    private final ClasspathPageRepository pageRepository;
    @NonNull
    private final RenderFunctionProvider renderFunctionProvider;

    @Override
    public Mono<String> render(String path) {
        return this.render(path, PageContext.empty());
    }

    @Override
    public Mono<String> render(String path, PageContext context) {
        return this.pageRepository.getPage(path).flatMap(content -> this.renderFunctionProvider.get(path, (String)content)).flatMap(renderFunction -> renderFunction.render(context));
    }

    private ClasspathPageProcessor(@NonNull ClasspathPageRepository pageRepository, @NonNull RenderFunctionProvider renderFunctionProvider) {
        if (pageRepository == null) {
            throw new NullPointerException("pageRepository is marked non-null but is null");
        }
        if (renderFunctionProvider == null) {
            throw new NullPointerException("renderFunctionProvider is marked non-null but is null");
        }
        this.pageRepository = pageRepository;
        this.renderFunctionProvider = renderFunctionProvider;
    }

    public static ClasspathPageProcessor of(@NonNull ClasspathPageRepository pageRepository, @NonNull RenderFunctionProvider renderFunctionProvider) {
        return new ClasspathPageProcessor(pageRepository, renderFunctionProvider);
    }
}

