/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PageContext {
    private static final PageContext EMPTY_CONTEXT = PageContext.builder().build();
    private final Map<Class<?>, Object> context;

    public static Builder builder() {
        return Builder.instance();
    }

    public static PageContext empty() {
        return EMPTY_CONTEXT;
    }

    public static <T> PageContext of(T value) {
        return PageContext.of(value.getClass(), value);
    }

    public static <T> PageContext of(Class<T> clazz, T value) {
        return PageContext.builder().put(clazz, value).build();
    }

    public static <T, T2> PageContext of(T value, T2 anotherValue) {
        return PageContext.of(value.getClass(), value, anotherValue.getClass(), anotherValue);
    }

    public static <T, T2> PageContext of(Class<T> clazz, T value, Class<T2> anotherClazz, T2 anotherValue) {
        return PageContext.builder().put(clazz, value).put(anotherClazz, anotherValue).build();
    }

    public <T> T get(Class<T> clazz) {
        return this.find(clazz).orElseThrow(() -> new IllegalArgumentException("Request context of type " + clazz.getSimpleName() + " is not available"));
    }

    public <T> Optional<T> find(Class<T> clazz) {
        return Optional.ofNullable(this.context.get(clazz));
    }

    public Builder enrich() {
        return Builder.of(this);
    }

    public <T> PageContext enrich(T value) {
        return Builder.of(this).put(value.getClass(), value).build();
    }

    public <T> PageContext enrich(Class<T> clazz, T value) {
        return Builder.of(this).put(clazz, value).build();
    }

    public <T, T2> PageContext enrich(T value, T2 anotherValue) {
        return Builder.of(this).put(value.getClass(), value).put(anotherValue.getClass(), anotherValue).build();
    }

    public <T, T2> PageContext enrich(Class<T> clazz, T value, Class<T2> anotherClazz, T2 anotherValue) {
        return Builder.of(this).put(clazz, value).put(anotherClazz, anotherValue).build();
    }

    public String toString() {
        return "PageContext(context=" + this.context + ")";
    }

    public PageContext(Map<Class<?>, Object> context) {
        this.context = context;
    }

    public static class Builder {
        private final Map<Class<?>, Object> context;

        public Builder(Map<Class<?>, Object> context) {
            this.context = context;
        }

        public static Builder instance() {
            return new Builder(new HashMap());
        }

        public static Builder of(PageContext context) {
            return new Builder(new HashMap(context.context));
        }

        public <T> Builder put(Class<T> clazz, T value) {
            this.context.put(clazz, value);
            return this;
        }

        public PageContext build() {
            return new PageContext(this.context);
        }
    }
}

