/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.processor;

import io.wttech.markuply.engine.pipeline.context.PageContext;
import io.wttech.markuply.engine.pipeline.http.HttpPipeline;
import io.wttech.markuply.engine.pipeline.http.proxy.request.RequestEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageResponse;
import io.wttech.markuply.engine.renderer.RenderFunctionProvider;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class BaseHttpPageProcessor
implements HttpPipeline {
    private static final Logger log = LoggerFactory.getLogger(BaseHttpPageProcessor.class);
    @NonNull
    private final HttpPageRepository pageRepository;
    @NonNull
    private final RenderFunctionProvider renderFunctionProvider;

    @Override
    public Mono<HttpPageResponse> render(String path, RequestEnricher enricher) {
        log.debug("Processing started for path: {}", (Object)path);
        return this.pageRepository.getPage(path, builder -> Mono.just((Object)enricher.enrich(builder))).flatMap(response -> this.processContent(path, (HttpPageResponse)response));
    }

    @Override
    public Mono<HttpPageResponse> render(String path) {
        log.debug("Processing started for path: {}", (Object)path);
        return this.pageRepository.getPage(path).flatMap(response -> this.processContent(path, (HttpPageResponse)response));
    }

    @Override
    public Mono<HttpPageResponse> render(String path, PageContext context) {
        log.debug("Processing started for path: {}", (Object)path);
        return this.pageRepository.getPage(path).flatMap(response -> this.processContent(path, (HttpPageResponse)response, context));
    }

    @Override
    public Mono<HttpPageResponse> render(String path, PageContext context, RequestEnricher enricher) {
        log.debug("Processing started for path: {}", (Object)path);
        return this.pageRepository.getPage(path, builder -> Mono.just((Object)enricher.enrich(builder))).flatMap(response -> this.processContent(path, (HttpPageResponse)response, context));
    }

    private Mono<HttpPageResponse> processContent(String path, HttpPageResponse response) {
        return this.processContent(path, response, PageContext.empty());
    }

    private Mono<HttpPageResponse> processContent(String path, HttpPageResponse response, PageContext context) {
        return this.renderFunctionProvider.get(path, response.getBody()).flatMap(renderFunction -> renderFunction.render(context)).map(response::withBody);
    }

    private BaseHttpPageProcessor(@NonNull HttpPageRepository pageRepository, @NonNull RenderFunctionProvider renderFunctionProvider) {
        if (pageRepository == null) {
            throw new NullPointerException("pageRepository is marked non-null but is null");
        }
        if (renderFunctionProvider == null) {
            throw new NullPointerException("renderFunctionProvider is marked non-null but is null");
        }
        this.pageRepository = pageRepository;
        this.renderFunctionProvider = renderFunctionProvider;
    }

    public static BaseHttpPageProcessor of(@NonNull HttpPageRepository pageRepository, @NonNull RenderFunctionProvider renderFunctionProvider) {
        return new BaseHttpPageProcessor(pageRepository, renderFunctionProvider);
    }
}

