/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.processor;

import io.wttech.markuply.engine.pipeline.context.PageContext;
import io.wttech.markuply.engine.pipeline.http.HttpPipeline;
import io.wttech.markuply.engine.pipeline.http.proxy.request.RequestEnricher;
import io.wttech.markuply.engine.pipeline.http.proxy.response.PageResponseEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageResponse;
import java.util.function.Supplier;
import lombok.NonNull;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringProxyHttpPageProcessor
implements HttpPipeline {
    @NonNull
    private final HttpPipeline processor;
    @NonNull
    private final PageResponseEnricher responseEnricher;

    @Override
    public Mono<HttpPageResponse> render(String path) {
        return this.withProxy(() -> this.processor.render(path));
    }

    @Override
    public Mono<HttpPageResponse> render(String path, RequestEnricher enricher) {
        return this.withProxy(() -> this.processor.render(path, enricher));
    }

    @Override
    public Mono<HttpPageResponse> render(String path, PageContext context) {
        return this.withProxy(() -> this.processor.render(path, context));
    }

    @Override
    public Mono<HttpPageResponse> render(String path, PageContext context, RequestEnricher enricher) {
        return this.withProxy(() -> this.processor.render(path, context, enricher));
    }

    private Mono<HttpPageResponse> withProxy(Supplier<Mono<HttpPageResponse>> supplier) {
        return Mono.deferContextual(Mono::just).map(context -> ((ServerWebExchange)context.get((Object)ServerWebExchangeContextFilter.EXCHANGE_CONTEXT_ATTRIBUTE)).getResponse()).flatMap(serverResponse -> this.enrichResponse((ServerHttpResponse)serverResponse, supplier));
    }

    private Mono<HttpPageResponse> enrichResponse(ServerHttpResponse serverResponse, Supplier<Mono<HttpPageResponse>> supplier) {
        return supplier.get().doOnNext(response -> this.responseEnricher.enrich((HttpPageResponse)response, serverResponse));
    }

    private SpringProxyHttpPageProcessor(@NonNull HttpPipeline processor, @NonNull PageResponseEnricher responseEnricher) {
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
        if (responseEnricher == null) {
            throw new NullPointerException("responseEnricher is marked non-null but is null");
        }
        this.processor = processor;
        this.responseEnricher = responseEnricher;
    }

    public static SpringProxyHttpPageProcessor instance(@NonNull HttpPipeline processor, @NonNull PageResponseEnricher responseEnricher) {
        return new SpringProxyHttpPageProcessor(processor, responseEnricher);
    }
}

