/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.processor.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.wttech.markuply.engine.MarkuplyException;
import io.wttech.markuply.engine.pipeline.http.HttpPipeline;
import io.wttech.markuply.engine.pipeline.http.processor.BaseHttpPageProcessor;
import io.wttech.markuply.engine.pipeline.http.processor.SpringProxyHttpPageProcessor;
import io.wttech.markuply.engine.pipeline.http.processor.configuration.HttpRepositoryConfigurator;
import io.wttech.markuply.engine.pipeline.http.processor.configuration.ProxyConfigurator;
import io.wttech.markuply.engine.pipeline.http.processor.configuration.SpringHttpRepositoryConfigurator;
import io.wttech.markuply.engine.pipeline.http.processor.configuration.UnidirectionalProxyConfigurator;
import io.wttech.markuply.engine.pipeline.http.proxy.request.PageRequestConfigurableEnricher;
import io.wttech.markuply.engine.pipeline.http.proxy.request.ReactiveRequestEnricher;
import io.wttech.markuply.engine.pipeline.http.proxy.response.PageResponseConfigurableEnricher;
import io.wttech.markuply.engine.pipeline.http.proxy.response.PageResponseEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.EnrichedHttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import io.wttech.markuply.engine.renderer.DirectRenderFunctionProvider;
import io.wttech.markuply.engine.renderer.RenderFunctionFactory;
import io.wttech.markuply.engine.renderer.RenderFunctionProvider;
import io.wttech.markuply.engine.renderer.cache.CachedRenderFunctionProvider;
import io.wttech.markuply.engine.renderer.cache.RenderFunctionCache;
import java.util.function.Consumer;

public class HttpPageProcessorConfigurator {
    private final RenderFunctionFactory renderFunctionFactory;
    private RenderFunctionProvider renderFunctionProvider;
    private HttpPageRepository httpPageRepository;
    private ReactiveRequestEnricher requestProxy;
    private PageResponseEnricher responseProxy;

    public HttpPipeline build() {
        if (this.httpPageRepository == null) {
            throw new MarkuplyException("Pipeline cannot be built. Repository has not been configured.");
        }
        if (this.renderFunctionProvider == null) {
            this.renderFunctionProvider = DirectRenderFunctionProvider.instance(this.renderFunctionFactory);
        }
        HttpPageRepository finalRepository = this.requestProxy != null ? EnrichedHttpPageRepository.instance(this.httpPageRepository, this.requestProxy) : this.httpPageRepository;
        BaseHttpPageProcessor baseProcessor = BaseHttpPageProcessor.of(finalRepository, this.renderFunctionProvider);
        return this.responseProxy != null ? SpringProxyHttpPageProcessor.instance(baseProcessor, this.responseProxy) : baseProcessor;
    }

    public HttpPageProcessorConfigurator renderFunctionCache(Consumer<Caffeine<Object, Object>> configurer) {
        Caffeine cacheBuilder = Caffeine.newBuilder();
        configurer.accept((Caffeine<Object, Object>)cacheBuilder);
        RenderFunctionCache cache = RenderFunctionCache.instance(this.renderFunctionFactory, (Caffeine<Object, Object>)cacheBuilder);
        this.renderFunctionProvider = CachedRenderFunctionProvider.instance(cache);
        return this;
    }

    public HttpPageProcessorConfigurator renderFunctionCache(RenderFunctionCache cache) {
        this.renderFunctionProvider = CachedRenderFunctionProvider.instance(cache);
        return this;
    }

    public HttpPageProcessorConfigurator repository(Consumer<HttpRepositoryConfigurator> configurer) {
        SpringHttpRepositoryConfigurator repositoryBuilder = SpringHttpRepositoryConfigurator.instance();
        configurer.accept(repositoryBuilder);
        this.httpPageRepository = repositoryBuilder.build();
        return this;
    }

    public HttpPageProcessorConfigurator requestProxy(Consumer<ProxyConfigurator> configurer) {
        UnidirectionalProxyConfigurator requestProxyBuilder = UnidirectionalProxyConfigurator.instance();
        configurer.accept(requestProxyBuilder);
        this.requestProxy = PageRequestConfigurableEnricher.builder().headerProxyConfiguration(requestProxyBuilder.buildHeaderProxyConfiguration()).staticHeaderConfiguration(requestProxyBuilder.buildStaticHeaderConfiguration()).build();
        return this;
    }

    public HttpPageProcessorConfigurator responseProxy(Consumer<ProxyConfigurator> configurer) {
        UnidirectionalProxyConfigurator requestProxyBuilder = UnidirectionalProxyConfigurator.instance();
        configurer.accept(requestProxyBuilder);
        this.responseProxy = PageResponseConfigurableEnricher.builder().headerProxyConfiguration(requestProxyBuilder.buildHeaderProxyConfiguration()).staticHeaderConfiguration(requestProxyBuilder.buildStaticHeaderConfiguration()).build();
        return this;
    }

    private HttpPageProcessorConfigurator(RenderFunctionFactory renderFunctionFactory) {
        this.renderFunctionFactory = renderFunctionFactory;
    }

    public static HttpPageProcessorConfigurator instance(RenderFunctionFactory renderFunctionFactory) {
        return new HttpPageProcessorConfigurator(renderFunctionFactory);
    }
}

