/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.processor.configuration;

import io.wttech.markuply.engine.MarkuplyException;
import io.wttech.markuply.engine.pipeline.http.processor.configuration.HttpRepositoryConfigurator;
import io.wttech.markuply.engine.pipeline.http.repository.BaseHttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import org.springframework.web.reactive.function.client.WebClient;

public class SpringHttpRepositoryConfigurator
implements HttpRepositoryConfigurator {
    private WebClient webClient;
    private String urlPrefix;

    public HttpPageRepository build() {
        if (this.webClient == null) {
            throw new MarkuplyException("HTTP repository cannot be built. Web client is not configured.");
        }
        String finalPrefix = this.urlPrefix != null ? this.urlPrefix : "";
        return BaseHttpPageRepository.of(this.webClient, finalPrefix);
    }

    @Override
    public SpringHttpRepositoryConfigurator urlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
        return this;
    }

    @Override
    public SpringHttpRepositoryConfigurator webClient(WebClient webClient) {
        this.webClient = webClient;
        return this;
    }

    private SpringHttpRepositoryConfigurator() {
    }

    public static SpringHttpRepositoryConfigurator instance() {
        return new SpringHttpRepositoryConfigurator();
    }
}

