/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.proxy.configuration;

import io.wttech.markuply.engine.pipeline.http.proxy.rule.HeaderMatchingRule;
import io.wttech.markuply.engine.pipeline.http.proxy.rule.HeaderMatchingRuleFactory;
import java.util.ArrayList;
import java.util.List;

public class HeaderProxyConfiguration {
    public static final HeaderProxyConfiguration EMPTY = HeaderProxyConfiguration.builder().build();
    private final List<HeaderMatchingRule> rules;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAllowed(String name) {
        return this.rules.stream().anyMatch(rule -> rule.matches(name));
    }

    HeaderProxyConfiguration(List<HeaderMatchingRule> rules) {
        this.rules = rules;
    }

    public List<HeaderMatchingRule> getRules() {
        return this.rules;
    }

    public static class Builder {
        private static final HeaderMatchingRuleFactory factory = HeaderMatchingRuleFactory.instance();
        private final List<HeaderMatchingRule> rules = new ArrayList<HeaderMatchingRule>();

        public Builder allow(String pattern) {
            this.rules.add(factory.allow(pattern));
            return this;
        }

        public Builder pattern(String pattern) {
            this.rules.add(factory.create(pattern));
            return this;
        }

        public HeaderProxyConfiguration build() {
            return new HeaderProxyConfiguration(this.rules);
        }
    }
}

