/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.proxy.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticHeaderConfiguration {
    public static final StaticHeaderConfiguration EMPTY = StaticHeaderConfiguration.builder().build();
    private final Map<String, List<String>> staticHeaders;

    public static Builder builder() {
        return new Builder();
    }

    StaticHeaderConfiguration(Map<String, List<String>> staticHeaders) {
        this.staticHeaders = staticHeaders;
    }

    public Map<String, List<String>> getStaticHeaders() {
        return this.staticHeaders;
    }

    public static class Builder {
        private final Map<String, List<String>> staticHeaders = new HashMap<String, List<String>>();

        public Builder setHeader(String name, List<String> values) {
            this.staticHeaders.put(name, values);
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.staticHeaders.put(name, Collections.singletonList(value));
            return this;
        }

        public StaticHeaderConfiguration build() {
            return new StaticHeaderConfiguration(this.staticHeaders);
        }
    }
}

