/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.proxy.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpPageRequest {
    private static final HttpPageRequest EMPTY = HttpPageRequest.builder().build();
    private final Map<String, List<String>> headers;

    public static Builder builder() {
        return new Builder();
    }

    public static HttpPageRequest empty() {
        return EMPTY;
    }

    public HttpPageRequest(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

        public Builder setHeader(String name, String value) {
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(value);
            this.headers.put(name, valueList);
            return this;
        }

        public Builder setHeader(String name, List<String> values) {
            ArrayList<String> valueList = new ArrayList<String>(values);
            this.headers.put(name, valueList);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.computeIfAbsent(name, key -> new ArrayList()).add(value);
            return this;
        }

        public Builder addHeader(String name, List<String> values) {
            values.forEach(value -> this.addHeader(name, (String)value));
            return this;
        }

        public Builder removeHeader(String name) {
            this.headers.remove(name);
            return this;
        }

        public HttpPageRequest build() {
            return new HttpPageRequest(this.headers);
        }
    }
}

